/*
 * Decompiled with CFR 0.152.
 */
package games.puzzle.slidingtiles;

import games.puzzle.slidingtiles.player.AbstractAI;
import games.puzzle.slidingtiles.player.BetterAI;
import games.puzzle.slidingtiles.player.INPuzzlePlayer;
import games.puzzle.slidingtiles.player.NPuzzlePlayer;
import games.puzzle.slidingtiles.player.RandomAI;
import games.puzzle.slidingtiles.ui.NPuzzleFrame;
import games.puzzle.slidingtiles.ui.display.INPuzzleDisplay;
import games.puzzle.slidingtiles.ui.display.NPuzzleDisplay;
import games.strategy.engine.data.DefaultUnitFactory;
import games.strategy.engine.data.IUnitFactory;
import games.strategy.engine.framework.IGame;
import games.strategy.engine.framework.IGameLoader;
import games.strategy.engine.gamePlayer.IGamePlayer;
import games.strategy.engine.message.IChannelSubscribor;
import games.strategy.engine.message.IRemote;
import java.lang.reflect.InvocationTargetException;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.SwingUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NPuzzle
implements IGameLoader {
    private transient NPuzzleDisplay m_display;
    private transient IGame m_game;
    private static final String HUMAN_PLAYER_TYPE = "Human";
    private static final String RANDOM_COMPUTER_PLAYER_TYPE = "Random AI";
    private static final String DFS_COMPUTER_PLAYER_TYPE = "Depth First Search AI";

    @Override
    public Set<IGamePlayer> createPlayers(Map<String, String> playerNames) {
        HashSet<IGamePlayer> players = new HashSet<IGamePlayer>();
        for (String name : playerNames.keySet()) {
            AbstractAI ai;
            String type = playerNames.get(name);
            if (type.equals(HUMAN_PLAYER_TYPE) || type.equals("Client")) {
                NPuzzlePlayer player = new NPuzzlePlayer(name, type);
                players.add(player);
                continue;
            }
            if (type.equals(RANDOM_COMPUTER_PLAYER_TYPE)) {
                ai = new RandomAI(name, type);
                players.add(ai);
                continue;
            }
            if (type.equals(DFS_COMPUTER_PLAYER_TYPE)) {
                ai = new BetterAI(name, type, BetterAI.Algorithm.DFS, BetterAI.Heuristic.NUMBER_OF_MISPLACED_TILES);
                players.add(ai);
                continue;
            }
            throw new IllegalStateException("Player type not recognized:" + type);
        }
        return players;
    }

    @Override
    public String[] getServerPlayerTypes() {
        return new String[]{HUMAN_PLAYER_TYPE, DFS_COMPUTER_PLAYER_TYPE, RANDOM_COMPUTER_PLAYER_TYPE};
    }

    @Override
    public void shutDown() {
        if (this.m_display != null) {
            this.m_game.removeDisplay(this.m_display);
            this.m_display.shutDown();
        }
    }

    @Override
    public void startGame(final IGame game, final Set<IGamePlayer> players) throws Exception {
        try {
            this.m_game = game;
            SwingUtilities.invokeAndWait(new Runnable(){

                public void run() {
                    final NPuzzleFrame frame = new NPuzzleFrame(game, players);
                    NPuzzle.this.m_display = new NPuzzleDisplay(frame);
                    NPuzzle.this.m_game.addDisplay(NPuzzle.this.m_display);
                    frame.setVisible(true);
                    NPuzzle.this.connectPlayers(players, frame);
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            frame.toFront();
                        }
                    });
                }
            });
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof Exception) {
                throw (Exception)e.getCause();
            }
            e.printStackTrace();
            throw new IllegalStateException(e.getCause().getMessage());
        }
    }

    private void connectPlayers(Set<IGamePlayer> players, NPuzzleFrame frame) {
        for (IGamePlayer player : players) {
            if (!(player instanceof NPuzzlePlayer)) continue;
            ((NPuzzlePlayer)player).setFrame(frame);
        }
    }

    @Override
    public Class<? extends IChannelSubscribor> getDisplayType() {
        return INPuzzleDisplay.class;
    }

    @Override
    public Class<? extends IRemote> getRemotePlayerType() {
        return INPuzzlePlayer.class;
    }

    @Override
    public IUnitFactory getUnitFactory() {
        return new DefaultUnitFactory();
    }
}

