/*
 * Decompiled with CFR 0.152.
 */
package games.puzzle.slidingtiles.delegate;

import games.puzzle.slidingtiles.attachments.Tile;
import games.puzzle.slidingtiles.delegate.PlayDelegate;
import games.puzzle.slidingtiles.delegate.SlidingTilesInitializationExtendedDelegateState;
import games.puzzle.slidingtiles.ui.display.INPuzzleDisplay;
import games.strategy.common.delegate.BaseDelegate;
import games.strategy.engine.data.Change;
import games.strategy.engine.data.ChangeFactory;
import games.strategy.engine.data.CompositeChange;
import games.strategy.engine.data.DefaultNamed;
import games.strategy.engine.data.GameMap;
import games.strategy.engine.data.Territory;
import games.strategy.engine.delegate.IDelegateBridge;
import games.strategy.engine.message.IRemote;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Random;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InitializationDelegate
extends BaseDelegate {
    @Override
    public void start(IDelegateBridge bridge) {
        super.start(bridge);
        GameMap map = this.getData().getMap();
        int width = map.getXDimension();
        int height = map.getYDimension();
        Territory[][] board = new Territory[width][height];
        INPuzzleDisplay display = (INPuzzleDisplay)this.m_bridge.getDisplayChannelBroadcaster();
        display.setStatus("Shuffling tiles...");
        this.m_bridge.getHistoryWriter().startEvent("Initializing board");
        CompositeChange initializingBoard = new CompositeChange();
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                board[x][y] = map.getTerritoryFromCoordinates(x, y);
                Tile tile = new Tile(x + y * width);
                Change change = ChangeFactory.addAttachmentChange(tile, board[x][y], "tile");
                initializingBoard.add(change);
            }
        }
        this.m_bridge.addChange(initializingBoard);
        display.initializeBoard();
        display.performPlay();
        this.m_bridge.getHistoryWriter().startEvent("Randomizing board");
        DefaultNamed blank = board[0][0];
        Territory dontChooseNextTime = null;
        DefaultNamed swap = null;
        int numberOfShuffles = this.getData().getProperties().get("Difficulty Level", 7);
        Random random = new Random();
        for (int i = 0; i < numberOfShuffles; ++i) {
            while (swap == null || swap.equals(dontChooseNextTime)) {
                ArrayList<Territory> neighbors = new ArrayList<Territory>(map.getNeighbors((Territory)blank));
                swap = (Territory)neighbors.get(random.nextInt(neighbors.size()));
            }
            try {
                Thread.sleep(75L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            PlayDelegate.swap(this.m_bridge, (Territory)swap, blank);
            dontChooseNextTime = blank;
            blank = swap;
            swap = null;
        }
        display.setStatus(" ");
    }

    @Override
    public void end() {
        super.end();
    }

    @Override
    public Serializable saveState() {
        SlidingTilesInitializationExtendedDelegateState state = new SlidingTilesInitializationExtendedDelegateState();
        state.superState = super.saveState();
        return state;
    }

    @Override
    public void loadState(Serializable state) {
        SlidingTilesInitializationExtendedDelegateState s = (SlidingTilesInitializationExtendedDelegateState)state;
        super.loadState(s.superState);
    }

    @Override
    public Class<? extends IRemote> getRemoteType() {
        return null;
    }
}

