/*
 * Decompiled with CFR 0.152.
 */
package games.puzzle.tictactoe;

import games.puzzle.tictactoe.player.AbstractAI;
import games.puzzle.tictactoe.player.BetterAI;
import games.puzzle.tictactoe.player.ITicTacToePlayer;
import games.puzzle.tictactoe.player.RandomAI;
import games.puzzle.tictactoe.player.TicTacToePlayer;
import games.puzzle.tictactoe.ui.TicTacToeFrame;
import games.puzzle.tictactoe.ui.display.ITicTacToeDisplay;
import games.puzzle.tictactoe.ui.display.TicTacToeDisplay;
import games.strategy.engine.data.DefaultUnitFactory;
import games.strategy.engine.data.IUnitFactory;
import games.strategy.engine.framework.IGame;
import games.strategy.engine.framework.IGameLoader;
import games.strategy.engine.gamePlayer.IGamePlayer;
import games.strategy.engine.message.IChannelSubscribor;
import games.strategy.engine.message.IRemote;
import java.lang.reflect.InvocationTargetException;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.SwingUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TicTacToe
implements IGameLoader {
    private transient TicTacToeDisplay m_display;
    private transient IGame m_game;
    private static final String HUMAN_PLAYER_TYPE = "Human";
    private static final String RANDOM_COMPUTER_PLAYER_TYPE = "Random AI";
    private static final String MINIMAX_COMPUTER_PLAYER_TYPE = "Minimax AI";
    private static final String ALPHABETA_COMPUTER_PLAYER_TYPE = "\u03b1\u03b2 AI";

    @Override
    public Set<IGamePlayer> createPlayers(Map<String, String> playerNames) {
        HashSet<IGamePlayer> players = new HashSet<IGamePlayer>();
        for (String name : playerNames.keySet()) {
            AbstractAI ai;
            String type = playerNames.get(name);
            if (type.equals(HUMAN_PLAYER_TYPE) || type.equals("Client")) {
                TicTacToePlayer player = new TicTacToePlayer(name, type);
                players.add(player);
                continue;
            }
            if (type.equals(RANDOM_COMPUTER_PLAYER_TYPE)) {
                ai = new RandomAI(name, type);
                players.add(ai);
                continue;
            }
            if (type.equals(MINIMAX_COMPUTER_PLAYER_TYPE)) {
                ai = new BetterAI(name, type, BetterAI.Algorithm.MINIMAX);
                players.add(ai);
                continue;
            }
            if (type.equals(ALPHABETA_COMPUTER_PLAYER_TYPE)) {
                ai = new BetterAI(name, type, BetterAI.Algorithm.ALPHABETA);
                players.add(ai);
                continue;
            }
            throw new IllegalStateException("Player type not recognized:" + type);
        }
        return players;
    }

    @Override
    public String[] getServerPlayerTypes() {
        return new String[]{HUMAN_PLAYER_TYPE, ALPHABETA_COMPUTER_PLAYER_TYPE, MINIMAX_COMPUTER_PLAYER_TYPE, RANDOM_COMPUTER_PLAYER_TYPE};
    }

    @Override
    public void shutDown() {
        if (this.m_display != null) {
            this.m_game.removeDisplay(this.m_display);
            this.m_display.shutDown();
        }
    }

    @Override
    public void startGame(final IGame game, final Set<IGamePlayer> players) throws Exception {
        try {
            this.m_game = game;
            SwingUtilities.invokeAndWait(new Runnable(){

                public void run() {
                    final TicTacToeFrame frame = new TicTacToeFrame(game, players);
                    TicTacToe.this.m_display = new TicTacToeDisplay(frame);
                    TicTacToe.this.m_game.addDisplay(TicTacToe.this.m_display);
                    frame.setVisible(true);
                    TicTacToe.this.connectPlayers(players, frame);
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            frame.toFront();
                        }
                    });
                }
            });
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof Exception) {
                throw (Exception)e.getCause();
            }
            e.printStackTrace();
            throw new IllegalStateException(e.getCause().getMessage());
        }
    }

    private void connectPlayers(Set<IGamePlayer> players, TicTacToeFrame frame) {
        for (IGamePlayer player : players) {
            if (!(player instanceof TicTacToePlayer)) continue;
            ((TicTacToePlayer)player).setFrame(frame);
        }
    }

    @Override
    public Class<? extends IChannelSubscribor> getDisplayType() {
        return ITicTacToeDisplay.class;
    }

    @Override
    public Class<? extends IRemote> getRemotePlayerType() {
        return ITicTacToePlayer.class;
    }

    @Override
    public IUnitFactory getUnitFactory() {
        return new DefaultUnitFactory();
    }
}

