/*
 * Decompiled with CFR 0.152.
 */
package games.puzzle.tictactoe.delegate;

import games.puzzle.tictactoe.delegate.TicTacToePlayExtendedDelegateState;
import games.puzzle.tictactoe.delegate.remote.IPlayDelegate;
import games.puzzle.tictactoe.ui.display.ITicTacToeDisplay;
import games.strategy.common.delegate.BaseDelegate;
import games.strategy.engine.data.Change;
import games.strategy.engine.data.ChangeFactory;
import games.strategy.engine.data.CompositeChange;
import games.strategy.engine.data.PlayerID;
import games.strategy.engine.data.Territory;
import games.strategy.engine.data.Unit;
import games.strategy.engine.delegate.IDelegateBridge;
import games.strategy.engine.message.IRemote;
import java.io.Serializable;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlayDelegate
extends BaseDelegate
implements IPlayDelegate {
    @Override
    public void start(IDelegateBridge bridge) {
        super.start(bridge);
        ITicTacToeDisplay display = (ITicTacToeDisplay)bridge.getDisplayChannelBroadcaster();
        display.setStatus(this.m_player.getName() + "'s turn");
    }

    @Override
    public void end() {
        super.end();
    }

    @Override
    public Serializable saveState() {
        TicTacToePlayExtendedDelegateState state = new TicTacToePlayExtendedDelegateState();
        state.superState = super.saveState();
        return state;
    }

    @Override
    public void loadState(Serializable state) {
        TicTacToePlayExtendedDelegateState s = (TicTacToePlayExtendedDelegateState)state;
        super.loadState(s.superState);
    }

    @Override
    public String play(Territory play) {
        String error = this.isValidPlay(play);
        if (error != null) {
            return error;
        }
        this.performPlay(play, this.m_player);
        return null;
    }

    private String isValidPlay(Territory territory) {
        if (territory.getOwner().equals(PlayerID.NULL_PLAYERID)) {
            return null;
        }
        return "Square is not empty";
    }

    private void performPlay(Territory at, PlayerID player) {
        ArrayList<Unit> units = new ArrayList<Unit>(1);
        units.add(this.getData().getUnitTypeList().getUnitType("ticmark").create(player));
        String transcriptText = player.getName() + " played in " + at.getName();
        this.m_bridge.getHistoryWriter().startEvent(transcriptText);
        this.m_bridge.getHistoryWriter().setRenderingData(units);
        Change place = ChangeFactory.addUnits(at, units);
        Change owner = ChangeFactory.changeOwner(at, player);
        CompositeChange change = new CompositeChange();
        change.add(place);
        change.add(owner);
        this.m_bridge.addChange(change);
        ITicTacToeDisplay display = (ITicTacToeDisplay)this.m_bridge.getDisplayChannelBroadcaster();
        display.performPlay(at);
    }

    @Override
    public Class<? extends IRemote> getRemoteType() {
        return IPlayDelegate.class;
    }
}

