/*
 * Decompiled with CFR 0.152.
 */
package games.puzzle.tictactoe.ui;

import games.strategy.engine.data.GameData;
import games.strategy.engine.data.GameMap;
import games.strategy.engine.data.Territory;
import java.awt.Dimension;
import java.awt.Polygon;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapData {
    private final Map<Territory, Polygon> m_polys = new HashMap<Territory, Polygon>();
    private final int m_gridWidth;
    private final int m_gridHeight;
    private final int m_squareWidth;
    private final int m_squareHeight;
    private final GameMap m_map;
    private final GameData m_gameData;

    public MapData(GameData gameData, int x_dim, int y_dim, int squareWidth, int squareHeight) {
        this.m_gridWidth = x_dim;
        this.m_gridHeight = y_dim;
        this.m_squareWidth = squareWidth;
        this.m_squareHeight = squareHeight;
        this.m_gameData = gameData;
        this.m_map = gameData.getMap();
        int x_offset = 0;
        int y_offset = 0;
        for (int y = 0; y < y_dim; ++y) {
            int x = 0;
            while (x < x_dim) {
                Territory territory = this.m_map.getTerritoryFromCoordinates(x++, y);
                this.m_polys.put(territory, new Polygon(new int[]{x_offset, x_offset + squareWidth, x_offset + squareWidth, x_offset}, new int[]{y_offset, y_offset, y_offset + squareHeight, y_offset + squareHeight}, 4));
                x_offset += squareWidth;
            }
            x_offset = 0;
            y_offset += squareHeight;
        }
    }

    GameData getGameData() {
        return this.m_gameData;
    }

    public Map<Territory, Polygon> getPolygons() {
        return this.m_polys;
    }

    public Polygon getPolygon(Territory at) {
        return this.m_polys.get(at);
    }

    public Territory getTerritoryAt(double x, double y) {
        int at_x = (int)(x / (double)this.m_squareWidth);
        int at_y = (int)(y / (double)this.m_squareHeight);
        if (at_x < 0 || at_x >= this.m_gridWidth || at_y < 0 || at_y >= this.m_gridHeight) {
            return null;
        }
        return this.m_map.getTerritoryFromCoordinates(at_x, at_y);
    }

    public Dimension getMapDimensions() {
        return new Dimension(this.m_gridWidth * this.m_squareWidth + 1, this.m_gridHeight * this.m_squareHeight + 1);
    }
}

