/*
 * Decompiled with CFR 0.152.
 */
package games.puzzle.tictactoe.ui;

import games.puzzle.tictactoe.ui.MapData;
import games.strategy.common.image.UnitImageFactory;
import games.strategy.engine.data.Change;
import games.strategy.engine.data.GameData;
import games.strategy.engine.data.PlayerID;
import games.strategy.engine.data.Territory;
import games.strategy.engine.data.Unit;
import games.strategy.engine.data.events.GameDataChangeListener;
import games.strategy.engine.gamePlayer.IPlayerBridge;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import javax.swing.JComponent;

public class MapPanel
extends JComponent
implements MouseListener {
    private final MapData m_mapData;
    private final GameData m_gameData;
    private Territory m_clickedAt = null;
    private final Map<Territory, Image> m_images;
    private CountDownLatch m_waiting = null;

    public MapPanel(MapData mapData) {
        this.m_mapData = mapData;
        this.m_gameData = this.m_mapData.getGameData();
        Dimension mapDimension = this.m_mapData.getMapDimensions();
        this.setMinimumSize(mapDimension);
        this.setPreferredSize(mapDimension);
        this.setSize(mapDimension);
        this.m_images = new HashMap<Territory, Image>();
        this.updateAllImages();
        this.addMouseListener(this);
        this.setOpaque(true);
        this.m_gameData.addDataChangeListener(new GameDataChangeListener(){

            public void gameDataChanged(Change change) {
                MapPanel.this.updateAllImages();
            }
        });
    }

    private void updateAllImages() {
        for (Territory at : this.m_mapData.getPolygons().keySet()) {
            this.updateImage(at);
        }
        this.repaint();
    }

    public Dimension getMapDimensions() {
        return this.m_mapData.getMapDimensions();
    }

    protected void performPlay(Territory at) {
    }

    private void updateImage(Territory at) {
        if (at != null) {
            if (at.getUnits().size() == 1) {
                UnitImageFactory f = new UnitImageFactory();
                Unit u = (Unit)at.getUnits().getUnits().toArray()[0];
                Image image = f.getImage(u.getType(), u.getOwner(), this.m_gameData);
                this.m_images.put(at, image);
            } else {
                this.m_images.remove(at);
            }
        }
    }

    protected void paintComponent(Graphics g) {
        g.setColor(Color.white);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        for (Map.Entry<Territory, Polygon> entry : this.m_mapData.getPolygons().entrySet()) {
            Polygon p = entry.getValue();
            Territory at = entry.getKey();
            Color backgroundColor = Color.WHITE;
            g.setColor(Color.black);
            Image image = this.m_images.get(at);
            if (image != null) {
                Rectangle square = p.getBounds();
                g.drawImage(image, square.x, square.y, square.width, square.height, backgroundColor, null);
            }
            g.drawPolygon(p);
        }
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
        this.m_clickedAt = this.m_mapData.getTerritoryAt(e.getX(), e.getY());
        if (this.m_waiting != null) {
            this.m_waiting.countDown();
        }
    }

    public void mouseReleased(MouseEvent e) {
    }

    public Territory waitForPlay(PlayerID player, IPlayerBridge bridge, CountDownLatch waiting) throws InterruptedException {
        if (waiting == null || waiting.getCount() != 1L) {
            throw new IllegalArgumentException("CountDownLatch must be non-null and have getCount()==1");
        }
        this.m_waiting = waiting;
        this.m_waiting.await();
        if (this.m_clickedAt == null) {
            this.m_clickedAt = null;
            throw new InterruptedException("Interrupted while waiting for play.");
        }
        Territory play = this.m_clickedAt;
        this.m_clickedAt = null;
        return play;
    }
}

