/*
 * Decompiled with CFR 0.152.
 */
package games.puzzle.tictactoe.ui;

import games.puzzle.tictactoe.ui.MapData;
import games.puzzle.tictactoe.ui.MapPanel;
import games.puzzle.tictactoe.ui.TicTacToeMenu;
import games.strategy.common.ui.MacWrapper;
import games.strategy.common.ui.MainGameFrame;
import games.strategy.engine.data.GameData;
import games.strategy.engine.data.PlayerID;
import games.strategy.engine.data.Territory;
import games.strategy.engine.framework.ClientGame;
import games.strategy.engine.framework.GameRunner;
import games.strategy.engine.framework.IGame;
import games.strategy.engine.framework.ServerGame;
import games.strategy.engine.framework.startup.ui.MainFrame;
import games.strategy.engine.gamePlayer.IGamePlayer;
import games.strategy.engine.gamePlayer.IPlayerBridge;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TicTacToeFrame
extends MainGameFrame {
    private GameData m_data;
    private IGame m_game;
    private MapPanel m_mapPanel;
    private JLabel m_status;
    private final JLabel m_error;
    private boolean m_gameOver = false;
    private CountDownLatch m_waiting = null;

    public TicTacToeFrame(IGame game, Set<IGamePlayer> players) {
        this.m_game = game;
        this.m_data = game.getData();
        int x_dim = this.m_data.getMap().getXDimension();
        int y_dim = this.m_data.getMap().getYDimension();
        MapData mapData = new MapData(this.m_data, x_dim, y_dim, 50, 50);
        this.m_mapPanel = new MapPanel(mapData);
        this.m_status = new JLabel(" ");
        this.m_status.setAlignmentX(0.5f);
        this.m_status.setBorder(BorderFactory.createEmptyBorder(20, 0, 0, 0));
        this.m_error = new JLabel(" ");
        this.m_error.setAlignmentX(0.5f);
        JPanel mainPanel = new JPanel();
        mainPanel.setBorder(BorderFactory.createEmptyBorder(20, 20, 20, 20));
        mainPanel.setLayout(new BoxLayout(mainPanel, 1));
        mainPanel.add(this.m_mapPanel);
        mainPanel.add(this.m_status);
        mainPanel.add(this.m_error);
        this.setContentPane(mainPanel);
        this.setJMenuBar(new TicTacToeMenu(this));
        this.setTitle(this.m_game.getData().getGameName());
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                TicTacToeFrame.this.leaveGame();
            }
        });
        this.pack();
        this.setResizable(false);
        this.setVisible(true);
    }

    public void performPlay(Territory at) {
        this.m_mapPanel.performPlay(at);
    }

    public Territory waitForPlay(PlayerID player, IPlayerBridge bridge) {
        if (this.m_gameOver) {
            this.m_waiting = new CountDownLatch(1);
            try {
                this.m_waiting.await();
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            return null;
        }
        Territory play = null;
        try {
            while (play == null) {
                this.m_waiting = new CountDownLatch(1);
                play = this.m_mapPanel.waitForPlay(player, bridge, this.m_waiting);
            }
        }
        catch (InterruptedException e) {
            return null;
        }
        return play;
    }

    @Override
    public IGame getGame() {
        return this.m_game;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void leaveGame() {
        int rVal;
        if (!this.m_gameOver && (rVal = JOptionPane.showConfirmDialog(this, "Are you sure you want to leave?\nUnsaved game data will be lost.", "Exit", 0)) != 0) {
            return;
        }
        if (this.m_waiting != null) {
            CountDownLatch countDownLatch = this.m_waiting;
            synchronized (countDownLatch) {
                while (this.m_waiting.getCount() > 0L) {
                    this.m_waiting.countDown();
                }
            }
        }
        if (this.m_game instanceof ServerGame) {
            ((ServerGame)this.m_game).stopGame();
        } else {
            this.m_game.getMessenger().shutDown();
            ((ClientGame)this.m_game).shutDown();
            MainFrame.getInstance().clientLeftGame();
        }
    }

    public void stopGame() {
        if (GameRunner.isMac()) {
            MacWrapper.unregisterShutdownHandler();
        }
        this.setVisible(false);
        this.dispose();
        this.m_game = null;
        if (this.m_data != null) {
            this.m_data.clearAllListeners();
        }
        this.m_data = null;
        this.m_mapPanel = null;
        this.m_status = null;
        for (WindowListener l : this.getWindowListeners()) {
            this.removeWindowListener(l);
        }
    }

    @Override
    public void shutdown() {
        int rVal;
        if (!this.m_gameOver && (rVal = JOptionPane.showConfirmDialog(this, "Are you sure you want to exit?\nUnsaved game data will be lost.", "Exit", 0)) != 0) {
            return;
        }
        System.exit(0);
    }

    public void setGameOver() {
        this.m_gameOver = true;
    }

    public boolean isGameOver() {
        return this.m_gameOver;
    }

    @Override
    public void notifyError(String error) {
        this.m_error.setText(error);
    }

    public void setStatus(String status) {
        this.m_error.setText(" ");
        this.m_status.setText(status);
    }
}

