/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.common.player.ai;

import games.strategy.common.player.ai.GameState;
import java.util.HashSet;
import java.util.Set;
import java.util.Stack;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AIAlgorithm {
    public static <Play> Stack<Play> depthFirstSearch(GameState<Play> state, int maxDepth) {
        Stack stack = new Stack();
        try {
            if (state.gameIsOver()) {
                return stack;
            }
            HashSet<GameState<Play>> visitedStates = new HashSet<GameState<Play>>();
            visitedStates.add(state);
            return AIAlgorithm.dfs(state, visitedStates, stack, 0, maxDepth);
        }
        catch (StackOverflowError e) {
            return null;
        }
    }

    private static <Play> Stack<Play> dfs(GameState<Play> state, Set<GameState<Play>> visitedStates, Stack<Play> plays, int depth, int maxDepth) {
        int playsSoFar = plays.size();
        if (depth < maxDepth) {
            int childCounter = -1;
            for (GameState<Play> child : state.successors()) {
                ++childCounter;
                if (visitedStates.contains(child)) continue;
                visitedStates.add(child);
                if (child.gameIsOver()) {
                    plays.push(child.getMove());
                    return plays;
                }
                if ((plays = AIAlgorithm.dfs(child, visitedStates, plays, depth + 1, maxDepth)).size() <= playsSoFar) continue;
                plays.push(child.getMove());
                return plays;
            }
        }
        return plays;
    }

    public static <Play> Play alphaBetaSearch(GameState<Play> state) {
        Pair<Float, Play> m = AIAlgorithm.maxValue(state, Float.NEGATIVE_INFINITY, Float.POSITIVE_INFINITY);
        return m.getSecond();
    }

    private static <Play> Pair<Float, Play> maxValue(GameState<Play> state, float alpha, float beta) {
        float value = Float.NEGATIVE_INFINITY;
        Object bestMove = null;
        for (GameState<Play> s : state.successors()) {
            Play a = s.getMove();
            float minValue = s.cutoffTest() ? s.getUtility() : AIAlgorithm.minValue(s, alpha, beta).getFirst().floatValue();
            if (minValue > value) {
                value = minValue;
                bestMove = a;
            }
            if (value >= beta) {
                return new Pair<Float, Object>(Float.valueOf(value), bestMove);
            }
            if (!(value > alpha)) continue;
            alpha = value;
        }
        return new Pair<Float, Object>(Float.valueOf(value), bestMove);
    }

    private static <Play> Pair<Float, Play> minValue(GameState<Play> state, float alpha, float beta) {
        float value = Float.POSITIVE_INFINITY;
        Object bestMove = null;
        for (GameState<Play> s : state.successors()) {
            Play a = s.getMove();
            float maxValue = s.cutoffTest() ? s.getUtility() : AIAlgorithm.maxValue(s, alpha, beta).getFirst().floatValue();
            if (maxValue < value) {
                value = maxValue;
                bestMove = a;
            }
            if (value <= alpha) {
                return new Pair<Float, Object>(Float.valueOf(value), bestMove);
            }
            if (!(value < beta)) continue;
            beta = value;
        }
        return new Pair<Float, Object>(Float.valueOf(value), bestMove);
    }

    public static <Play> Play minimaxSearch(GameState<Play> state) {
        Pair<Float, Play> m = AIAlgorithm.maxValue(state);
        return m.getSecond();
    }

    private static <Play> Pair<Float, Play> maxValue(GameState<Play> state) {
        float value = Float.NEGATIVE_INFINITY;
        Object bestMove = null;
        for (GameState<Play> s : state.successors()) {
            Play a = s.getMove();
            float minValue = s.gameIsOver() ? s.getUtility() : AIAlgorithm.minValue(s).getFirst().floatValue();
            if (!(minValue > value)) continue;
            value = minValue;
            bestMove = a;
        }
        return new Pair<Float, Object>(Float.valueOf(value), bestMove);
    }

    private static <Play> Pair<Float, Play> minValue(GameState<Play> state) {
        float value = Float.POSITIVE_INFINITY;
        Object bestMove = null;
        for (GameState<Play> s : state.successors()) {
            Play a = s.getMove();
            float maxValue = s.gameIsOver() ? s.getUtility() : AIAlgorithm.maxValue(s).getFirst().floatValue();
            if (!(maxValue < value)) continue;
            value = maxValue;
            bestMove = a;
        }
        return new Pair<Float, Object>(Float.valueOf(value), bestMove);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Pair<First, Second> {
        private final First m_first;
        private final Second m_second;

        Pair(First first, Second second) {
            this.m_first = first;
            this.m_second = second;
        }

        First getFirst() {
            return this.m_first;
        }

        Second getSecond() {
            return this.m_second;
        }
    }
}

