/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.common.ui;

import com.apple.eawt.Application;
import com.apple.eawt.ApplicationAdapter;
import com.apple.eawt.ApplicationEvent;
import games.strategy.common.ui.MacWrapper;
import games.strategy.common.ui.MainGameFrame;
import games.strategy.common.ui.PlayersPanel;
import games.strategy.debug.Console;
import games.strategy.engine.EngineVersion;
import games.strategy.engine.data.GameData;
import games.strategy.engine.framework.GameRunner;
import games.strategy.engine.framework.IGame;
import games.strategy.engine.framework.ServerGame;
import games.strategy.engine.framework.networkMaintenance.BanPlayerAction;
import games.strategy.engine.framework.networkMaintenance.BootPlayerAction;
import games.strategy.engine.framework.networkMaintenance.MutePlayerAction;
import games.strategy.engine.framework.networkMaintenance.SetPasswordAction;
import games.strategy.engine.framework.startup.login.ClientLoginValidator;
import games.strategy.engine.framework.startup.ui.InGameLobbyWatcher;
import games.strategy.engine.framework.ui.SaveGameFileChooser;
import games.strategy.engine.lobby.client.ui.action.EditGameCommentAction;
import games.strategy.engine.lobby.client.ui.action.RemoveGameFromLobbyAction;
import games.strategy.engine.message.DummyMessenger;
import games.strategy.net.BareBonesBrowserLaunch;
import games.strategy.net.IServerMessenger;
import java.awt.Component;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FilenameFilter;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicGameMenuBar<CustomGameFrame extends MainGameFrame>
extends JMenuBar {
    protected final CustomGameFrame m_frame;

    public BasicGameMenuBar(CustomGameFrame frame) {
        this.m_frame = frame;
        this.createFileMenu(this);
        this.createGameSpecificMenus(this);
        InGameLobbyWatcher watcher = this.createLobbyMenu(this);
        this.createNetworkMenu(this, watcher);
        this.createWebHelpMenu(this);
        this.createHelpMenu(this);
    }

    protected void createGameSpecificMenus(JMenuBar menuBar) {
    }

    protected InGameLobbyWatcher createLobbyMenu(JMenuBar menuBar) {
        if (!(((MainGameFrame)this.m_frame).getGame() instanceof ServerGame)) {
            return null;
        }
        ServerGame serverGame = (ServerGame)((MainGameFrame)this.m_frame).getGame();
        InGameLobbyWatcher watcher = serverGame.getInGameLobbyWatcher();
        if (watcher == null || !watcher.isActive()) {
            return watcher;
        }
        JMenu lobby = new JMenu("Lobby");
        menuBar.add(lobby);
        lobby.add(new EditGameCommentAction(watcher, (Component)this.m_frame));
        lobby.add(new RemoveGameFromLobbyAction(watcher));
        return watcher;
    }

    protected void createNetworkMenu(JMenuBar menuBar, InGameLobbyWatcher watcher) {
        if (this.getGame().getMessenger() instanceof DummyMessenger) {
            return;
        }
        JMenu menuNetwork = new JMenu("Network");
        this.addAllowObserversToJoin(menuNetwork);
        this.addBootPlayer(menuNetwork);
        this.addBanPlayer(menuNetwork);
        this.addMutePlayer(menuNetwork);
        this.addSetGamePassword(menuNetwork, watcher);
        this.addShowPlayers(menuNetwork);
        menuBar.add(menuNetwork);
    }

    protected void addAllowObserversToJoin(JMenu parentMenu) {
        if (!this.getGame().getMessenger().isServer()) {
            return;
        }
        final IServerMessenger messeneger = (IServerMessenger)this.getGame().getMessenger();
        final JCheckBoxMenuItem allowObservers = new JCheckBoxMenuItem("Allow New Observers");
        allowObservers.setSelected(messeneger.isAcceptNewConnections());
        allowObservers.addActionListener(new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                messeneger.setAcceptNewConnections(allowObservers.isSelected());
            }
        });
        parentMenu.add(allowObservers);
    }

    protected void addBootPlayer(JMenu parentMenu) {
        if (!this.getGame().getMessenger().isServer()) {
            return;
        }
        IServerMessenger messenger = (IServerMessenger)this.getGame().getMessenger();
        BootPlayerAction boot = new BootPlayerAction(this, messenger);
        parentMenu.add(boot);
    }

    protected void addBanPlayer(JMenu parentMenu) {
        if (!this.getGame().getMessenger().isServer()) {
            return;
        }
        IServerMessenger messenger = (IServerMessenger)this.getGame().getMessenger();
        BanPlayerAction ban = new BanPlayerAction(this, messenger);
        parentMenu.add(ban);
    }

    protected void addMutePlayer(JMenu parentMenu) {
        if (!this.getGame().getMessenger().isServer()) {
            return;
        }
        IServerMessenger messenger = (IServerMessenger)this.getGame().getMessenger();
        MutePlayerAction mute = new MutePlayerAction(this, messenger);
        parentMenu.add(mute);
    }

    protected void addSetGamePassword(JMenu parentMenu, InGameLobbyWatcher watcher) {
        if (!this.getGame().getMessenger().isServer()) {
            return;
        }
        IServerMessenger messenger = (IServerMessenger)this.getGame().getMessenger();
        parentMenu.add(new SetPasswordAction(this, watcher, (ClientLoginValidator)messenger.getLoginValidator()));
    }

    protected void addShowPlayers(JMenu menuGame) {
        if (!this.getGame().getData().getProperties().getEditableProperties().isEmpty()) {
            AbstractAction optionsAction = new AbstractAction("Show Who is Who..."){

                public void actionPerformed(ActionEvent e) {
                    PlayersPanel.showPlayers(BasicGameMenuBar.this.getGame(), BasicGameMenuBar.this.m_frame);
                }
            };
            menuGame.add(optionsAction);
        }
    }

    protected void createHelpMenu(JMenuBar menuBar) {
        JMenu helpMenu = new JMenu("Help");
        menuBar.add(helpMenu);
        this.addGameSpecificHelpMenus(helpMenu);
        this.addGameNotesMenu(helpMenu);
        this.addConsoleMenu(helpMenu);
        this.addAboutMenu(helpMenu);
    }

    private void createWebHelpMenu(JMenuBar menuBar) {
        JMenu web = new JMenu("Web");
        menuBar.add(web);
        this.addWebMenu(web);
    }

    private void addWebMenu(JMenu parentMenu) {
        JMenuItem hostingLink = new JMenuItem("How to Host...");
        JMenuItem mapLink = new JMenuItem("Install Maps...");
        JMenuItem bugReport = new JMenuItem("Bug Report...");
        JMenuItem lobbyRules = new JMenuItem("Lobby Rules...");
        JMenuItem warClub = new JMenuItem("War Club & Ladder...");
        JMenuItem devForum = new JMenuItem("Developer Forum...");
        JMenuItem donateLink = new JMenuItem("Donate...");
        JMenuItem guidesLink = new JMenuItem("Guides...");
        hostingLink.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                try {
                    BareBonesBrowserLaunch.openURL("http://tripleadev.1671093.n2.nabble.com/Download-Maps-Links-Hosting-Games-General-Information-tp4074312p4085700.html");
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
            }
        });
        mapLink.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                try {
                    BareBonesBrowserLaunch.openURL("http://tripleadev.1671093.n2.nabble.com/Download-Maps-Links-Hosting-Games-General-Information-tp4074312p4074312.html");
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
            }
        });
        bugReport.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                try {
                    BareBonesBrowserLaunch.openURL("https://sourceforge.net/tracker/?group_id=44492");
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
            }
        });
        lobbyRules.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                try {
                    BareBonesBrowserLaunch.openURL("http://www.tripleawarclub.org/modules/newbb/viewtopic.php?topic_id=100&forum=1");
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
            }
        });
        warClub.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                try {
                    BareBonesBrowserLaunch.openURL("http://www.tripleawarclub.org/");
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
            }
        });
        devForum.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                try {
                    BareBonesBrowserLaunch.openURL("http://triplea.sourceforge.net/mywiki/Forum");
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
            }
        });
        donateLink.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                try {
                    BareBonesBrowserLaunch.openURL("https://sourceforge.net/donate/index.php?group_id=44492");
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
            }
        });
        guidesLink.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                try {
                    BareBonesBrowserLaunch.openURL("http://triplea.sourceforge.net/mywiki/Guides");
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
            }
        });
        parentMenu.add(hostingLink);
        parentMenu.add(mapLink);
        parentMenu.add(bugReport);
        parentMenu.add(lobbyRules);
        parentMenu.add(warClub);
        parentMenu.add(devForum);
        parentMenu.add(donateLink);
        parentMenu.add(guidesLink);
    }

    protected void addGameSpecificHelpMenus(JMenu helpMenu) {
    }

    protected void addConsoleMenu(JMenu parentMenu) {
        parentMenu.add(new AbstractAction("Show Console..."){

            public void actionPerformed(ActionEvent e) {
                Console.getConsole().setVisible(true);
            }
        });
    }

    protected void addAboutMenu(JMenu parentMenu) {
        String text = "<h2>" + this.getData().getGameName() + "</h2>" + "<p><b>Engine Version:</b> " + EngineVersion.VERSION.toString() + "<br><b>Game:</b> " + this.getData().getGameName() + "<br><b>Game Version:</b>" + this.getData().getGameVersion() + "</p>" + "<p>For more information please visit,<br><br>" + "<b><a hlink='http://triplea.sourceforge.net/'>http://triplea.sourceforge.net/</a></b><br><br>";
        final JEditorPane editorPane = new JEditorPane();
        editorPane.setBorder(null);
        editorPane.setBackground(this.getBackground());
        editorPane.setEditable(false);
        editorPane.setContentType("text/html");
        editorPane.setText(text);
        JScrollPane scroll = new JScrollPane(editorPane);
        scroll.setBorder(null);
        if (System.getProperty("mrj.version") == null) {
            parentMenu.addSeparator();
            parentMenu.add(new AbstractAction("About..."){

                public void actionPerformed(ActionEvent e) {
                    JOptionPane.showMessageDialog(BasicGameMenuBar.this.m_frame, editorPane, "About " + ((MainGameFrame)BasicGameMenuBar.this.m_frame).getGame().getData().getGameName(), -1);
                }
            });
        } else {
            Application.getApplication().addApplicationListener(new ApplicationAdapter(){

                public void handleAbout(ApplicationEvent event) {
                    event.setHandled(true);
                    JOptionPane.showMessageDialog(BasicGameMenuBar.this.m_frame, editorPane, "About " + ((MainGameFrame)BasicGameMenuBar.this.m_frame).getGame().getData().getGameName(), -1);
                }
            });
        }
    }

    protected void addGameNotesMenu(JMenu parentMenu) {
        final String notes = this.getData().getProperties().get("notes", "");
        if (notes != null && notes.trim().length() != 0) {
            parentMenu.add(new AbstractAction("Game Notes..."){

                public void actionPerformed(ActionEvent e) {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            JEditorPane editorPane = new JEditorPane();
                            editorPane.setEditable(false);
                            editorPane.setContentType("text/html");
                            editorPane.setText(notes);
                            final JScrollPane scroll = new JScrollPane(editorPane);
                            final JDialog dialog = new JDialog((Frame)BasicGameMenuBar.this.m_frame);
                            dialog.setModal(true);
                            dialog.add((Component)scroll, "Center");
                            JPanel buttons = new JPanel();
                            final JButton button = new JButton(new AbstractAction("OK"){

                                public void actionPerformed(ActionEvent e) {
                                    dialog.setVisible(false);
                                }
                            });
                            buttons.add(button);
                            dialog.getRootPane().setDefaultButton(button);
                            dialog.add((Component)buttons, "South");
                            dialog.pack();
                            if (dialog.getWidth() < 400) {
                                dialog.setSize(400, dialog.getHeight());
                            }
                            if (dialog.getHeight() < 300) {
                                dialog.setSize(dialog.getWidth(), 300);
                            }
                            if (dialog.getWidth() > 800) {
                                dialog.setSize(800, dialog.getHeight());
                            }
                            if (dialog.getHeight() > 600) {
                                dialog.setSize(dialog.getWidth(), 600);
                            }
                            dialog.setLocationRelativeTo((Component)BasicGameMenuBar.this.m_frame);
                            dialog.addWindowListener(new WindowAdapter(){

                                public void windowOpened(WindowEvent e) {
                                    scroll.getVerticalScrollBar().getModel().setValue(0);
                                    scroll.getHorizontalScrollBar().getModel().setValue(0);
                                    button.requestFocus();
                                }
                            });
                            dialog.setVisible(true);
                            dialog.dispose();
                        }
                    });
                }
            });
        }
    }

    protected void createFileMenu(JMenuBar menuBar) {
        JMenu fileMenu = new JMenu("File");
        menuBar.add(fileMenu);
        this.addSaveMenu(fileMenu);
        this.addExitMenu(fileMenu);
    }

    protected void addSaveMenu(JMenu parent) {
        JMenuItem menuFileSave = new JMenuItem(new AbstractAction("Save..."){

            public void actionPerformed(ActionEvent e) {
                if (GameRunner.isMac()) {
                    FileDialog fileDialog = new FileDialog((Frame)BasicGameMenuBar.this.m_frame);
                    fileDialog.setMode(1);
                    SaveGameFileChooser.ensureDefaultDirExists();
                    fileDialog.setDirectory(SaveGameFileChooser.DEFAULT_DIRECTORY.getPath());
                    fileDialog.setFilenameFilter(new FilenameFilter(){

                        public boolean accept(File dir, String name) {
                            return name.endsWith(".tsvg") || name.endsWith(".svg");
                        }
                    });
                    fileDialog.setVisible(true);
                    String fileName = fileDialog.getFile();
                    String dirName = fileDialog.getDirectory();
                    if (fileName == null) {
                        return;
                    }
                    if (!fileName.endsWith(".tsvg")) {
                        fileName = fileName + ".tsvg";
                    }
                    File f = new File(dirName, fileName);
                    BasicGameMenuBar.this.getGame().saveGame(f);
                    JOptionPane.showMessageDialog(BasicGameMenuBar.this.m_frame, "Game Saved", "Game Saved", 1);
                } else {
                    SaveGameFileChooser fileChooser = SaveGameFileChooser.getInstance();
                    int rVal = fileChooser.showSaveDialog((Component)BasicGameMenuBar.this.m_frame);
                    if (rVal == 0) {
                        int choice;
                        File f = fileChooser.getSelectedFile();
                        if (GameRunner.isWindows()) {
                            int slashIndex = Math.min(f.getPath().lastIndexOf("\\"), f.getPath().length());
                            String filePath = f.getPath().substring(0, slashIndex);
                            if (!fileChooser.getCurrentDirectory().toString().equals(filePath)) {
                                int choice2 = JOptionPane.showConfirmDialog(BasicGameMenuBar.this.m_frame, "Sub directories are not allowed in the file name.  Please rename it.", "Cancel?", -1, 2);
                                return;
                            }
                        }
                        if (!f.getName().toLowerCase().endsWith(".tsvg")) {
                            f = new File(f.getParent(), f.getName() + ".tsvg");
                        }
                        if (f.exists() && (choice = JOptionPane.showConfirmDialog(BasicGameMenuBar.this.m_frame, "A file by that name already exists. Do you wish to over write it?", "Over-write?", 0, 2)) != 0) {
                            return;
                        }
                        BasicGameMenuBar.this.getGame().saveGame(f);
                        JOptionPane.showMessageDialog(BasicGameMenuBar.this.m_frame, "Game Saved", "Game Saved", 1);
                    }
                }
            }
        });
        menuFileSave.setAccelerator(KeyStroke.getKeyStroke(83, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        parent.add(menuFileSave);
    }

    protected void addExitMenu(JMenu parentMenu) {
        boolean isMac = GameRunner.isMac();
        JMenuItem leaveGameMenuExit = new JMenuItem(new AbstractAction("Leave Game"){

            public void actionPerformed(ActionEvent e) {
                ((MainGameFrame)BasicGameMenuBar.this.m_frame).leaveGame();
            }
        });
        if (isMac) {
            leaveGameMenuExit.setAccelerator(KeyStroke.getKeyStroke(76, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        } else {
            leaveGameMenuExit.setAccelerator(KeyStroke.getKeyStroke(81, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        }
        parentMenu.add(leaveGameMenuExit);
        if (isMac) {
            MacWrapper.registerMacShutdownHandler(this.m_frame);
        } else {
            JMenuItem menuFileExit = new JMenuItem(new AbstractAction("Exit"){

                public void actionPerformed(ActionEvent e) {
                    ((MainGameFrame)BasicGameMenuBar.this.m_frame).shutdown();
                }
            });
            parentMenu.add(menuFileExit);
        }
    }

    public IGame getGame() {
        return ((MainGameFrame)this.m_frame).getGame();
    }

    public GameData getData() {
        return ((MainGameFrame)this.m_frame).getGame().getData();
    }
}

