/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.engine.chat;

import games.strategy.engine.chat.IChatChannel;
import games.strategy.engine.chat.IChatController;
import games.strategy.engine.lobby.server.ModeratorController;
import games.strategy.engine.message.IChannelMessenger;
import games.strategy.engine.message.IRemoteMessenger;
import games.strategy.engine.message.MessageContext;
import games.strategy.engine.message.RemoteName;
import games.strategy.net.IConnectionChangeListener;
import games.strategy.net.IMessenger;
import games.strategy.net.INode;
import games.strategy.net.IServerMessenger;
import games.strategy.net.Messengers;
import games.strategy.util.Tuple;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChatController
implements IChatController {
    private static final Logger s_logger = Logger.getLogger(ChatController.class.getName());
    private static final String CHAT_REMOTE = "_ChatRmt";
    private static final String CHAT_CHANNEL = "_ChatCtrl";
    private final IMessenger m_messenger;
    private final IRemoteMessenger m_remoteMessenger;
    private final ModeratorController m_moderatorController;
    private final IChannelMessenger m_channelMessenger;
    private final String m_chatName;
    private final Map<INode, IChatController.Tag> m_chatters = new HashMap<INode, IChatController.Tag>();
    protected final Object m_mutex = new Object();
    private final String m_chatChannel;
    private long m_version;
    private final ScheduledExecutorService m_pingThread = Executors.newScheduledThreadPool(1);
    private final IConnectionChangeListener m_connectionChangeListener = new IConnectionChangeListener(){

        public void connectionAdded(INode to) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void connectionRemoved(INode to) {
            Object object = ChatController.this.m_mutex;
            synchronized (object) {
                if (ChatController.this.m_chatters.keySet().contains(to)) {
                    ChatController.this.leaveChatInternal(to);
                }
            }
        }
    };

    public static RemoteName getChatControlerRemoteName(String chatName) {
        return new RemoteName(CHAT_REMOTE + chatName, IChatController.class);
    }

    public static String getChatChannelName(String chatName) {
        return CHAT_CHANNEL + chatName;
    }

    public ChatController(String name, IMessenger messenger, IRemoteMessenger remoteMessenger, IChannelMessenger channelMessenger, ModeratorController moderatorController) {
        this.m_chatName = name;
        this.m_messenger = messenger;
        this.m_remoteMessenger = remoteMessenger;
        this.m_moderatorController = moderatorController;
        this.m_channelMessenger = channelMessenger;
        this.m_chatChannel = ChatController.getChatChannelName(name);
        this.m_remoteMessenger.registerRemote(this, ChatController.getChatControlerRemoteName(name));
        ((IServerMessenger)this.m_messenger).addConnectionChangeListener(this.m_connectionChangeListener);
        this.m_pingThread.scheduleAtFixedRate(new Runnable(){

            public void run() {
                try {
                    ChatController.this.getChatBroadcaster().ping();
                }
                catch (Exception e) {
                    s_logger.log(Level.SEVERE, "Error pinging", e);
                }
            }
        }, 3L, 1L, TimeUnit.MINUTES);
    }

    public ChatController(String name, Messengers messenger, ModeratorController moderatorController) {
        this(name, messenger.getMessenger(), messenger.getRemoteMessenger(), messenger.getChannelMessenger(), moderatorController);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deactivate() {
        this.m_pingThread.shutdown();
        Object object = this.m_mutex;
        synchronized (object) {
            IChatChannel chatter = this.getChatBroadcaster();
            for (INode node : this.m_chatters.keySet()) {
                ++this.m_version;
                chatter.speakerRemoved(node, this.m_version);
            }
            this.m_remoteMessenger.unregisterRemote(ChatController.getChatControlerRemoteName(this.m_chatName));
        }
        ((IServerMessenger)this.m_messenger).removeConnectionChangeListener(this.m_connectionChangeListener);
    }

    private IChatChannel getChatBroadcaster() {
        IChatChannel chatter = (IChatChannel)this.m_channelMessenger.getChannelBroadcastor(new RemoteName(this.m_chatChannel, IChatChannel.class));
        return chatter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Tuple<Map<INode, IChatController.Tag>, Long> joinChat() {
        INode node = MessageContext.getSender();
        s_logger.info("Chatter:" + node + " is joining chat:" + this.m_chatName);
        IChatController.Tag tag = this.m_moderatorController.isPlayerAdmin(node) ? IChatController.Tag.MODERATOR : IChatController.Tag.NONE;
        Object object = this.m_mutex;
        synchronized (object) {
            this.m_chatters.put(node, tag);
            ++this.m_version;
            this.getChatBroadcaster().speakerAdded(node, tag, this.m_version);
            HashMap<INode, IChatController.Tag> copy = new HashMap<INode, IChatController.Tag>(this.m_chatters);
            return new Tuple<Map<INode, IChatController.Tag>, Long>(copy, this.m_version);
        }
    }

    @Override
    public void leaveChat() {
        this.leaveChatInternal(MessageContext.getSender());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void leaveChatInternal(INode node) {
        long version;
        Object object = this.m_mutex;
        synchronized (object) {
            this.m_chatters.remove(node);
            ++this.m_version;
            version = this.m_version;
        }
        this.getChatBroadcaster().speakerRemoved(node, version);
        s_logger.info("Chatter:" + node + " has left chat:" + this.m_chatName);
    }
}

