/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.engine.chat;

import games.strategy.engine.chat.Chat;
import games.strategy.engine.chat.ChatFloodControl;
import games.strategy.engine.chat.ChatMessage;
import games.strategy.engine.chat.IChatListener;
import games.strategy.net.INode;
import games.strategy.sound.ClipPlayer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.lang.reflect.InvocationTargetException;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BoundedRangeModel;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChatMessagePanel
extends JPanel
implements IChatListener {
    private final ChatFloodControl floodControl = new ChatFloodControl();
    private static final int MAX_LINES = 5000;
    private JTextPane m_text;
    private JScrollPane m_scrollPane;
    private JTextField m_nextMessage;
    private JButton m_send;
    private JButton m_setStatus;
    private Chat m_chat;
    private boolean m_showTime = false;
    private final SimpleDateFormat simpleDateFormat = new SimpleDateFormat("'('HH:mm:ss')'");
    private final SimpleAttributeSet bold = new SimpleAttributeSet();
    private final SimpleAttributeSet italic = new SimpleAttributeSet();
    private final SimpleAttributeSet normal = new SimpleAttributeSet();
    public static final String ME = "/me ";
    private final Action m_setStatusAction = new AbstractAction("Status..."){

        public void actionPerformed(ActionEvent e) {
            String status = JOptionPane.showInputDialog(JOptionPane.getFrameForComponent(ChatMessagePanel.this), "Enter Status Text (leave blank for no status)", "");
            if (status != null) {
                if (status.trim().length() == 0) {
                    status = null;
                }
                ChatMessagePanel.this.m_chat.getStatusManager().setStatus(status);
            }
        }
    };
    private final Action m_sendAction = new AbstractAction("Send"){

        public void actionPerformed(ActionEvent e) {
            if (ChatMessagePanel.this.m_nextMessage.getText().trim().length() == 0) {
                return;
            }
            if (ChatMessagePanel.isThirdPerson(ChatMessagePanel.this.m_nextMessage.getText())) {
                ChatMessagePanel.this.m_chat.sendMessage(ChatMessagePanel.this.m_nextMessage.getText().substring(ChatMessagePanel.ME.length()), true);
            } else {
                ChatMessagePanel.this.m_chat.sendMessage(ChatMessagePanel.this.m_nextMessage.getText(), false);
            }
            ChatMessagePanel.this.m_nextMessage.setText("");
        }
    };
    private final Action m_DownAction = new AbstractAction(){

        public void actionPerformed(ActionEvent e) {
            if (ChatMessagePanel.this.m_chat == null) {
                return;
            }
            ChatMessagePanel.this.m_chat.getSentMessagesHistory().next();
            ChatMessagePanel.this.m_nextMessage.setText(ChatMessagePanel.this.m_chat.getSentMessagesHistory().current());
        }
    };
    private final Action m_UpAction = new AbstractAction(){

        public void actionPerformed(ActionEvent e) {
            if (ChatMessagePanel.this.m_chat == null) {
                return;
            }
            ChatMessagePanel.this.m_chat.getSentMessagesHistory().prev();
            ChatMessagePanel.this.m_nextMessage.setText(ChatMessagePanel.this.m_chat.getSentMessagesHistory().current());
        }
    };

    public static boolean isThirdPerson(String msg) {
        return msg.toLowerCase().startsWith(ME);
    }

    public ChatMessagePanel(Chat chat) {
        this.init();
        this.setChat(chat);
    }

    private void init() {
        this.createComponents();
        this.layoutComponents();
        StyleConstants.setBold(this.bold, true);
        StyleConstants.setItalic(this.italic, true);
        this.setSize(300, 200);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setChat(final Chat chat) {
        if (!SwingUtilities.isEventDispatchThread()) {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    public void run() {
                        ChatMessagePanel.this.setChat(chat);
                    }
                });
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
            return;
        }
        if (this.m_chat != null) {
            this.m_chat.removeChatListener(this);
            this.cleanupKeyMap();
        }
        this.m_chat = chat;
        if (this.m_chat != null) {
            this.setupKeyMap();
            this.m_chat.addChatListener(this);
            this.m_send.setEnabled(true);
            this.m_text.setEnabled(true);
            Object object = this.m_chat.getMutex();
            synchronized (object) {
                this.m_text.setText("");
                for (ChatMessage message : this.m_chat.getChatHistory()) {
                    if (message.getFrom().equals(this.m_chat.getServerNode().getName())) {
                        if (message.getMessage().equals("?YOUR LOBBY CHATTING HAS BEEN TEMPORARILY 'MUTED' BY THE ADMINS, TRY AGAIN LATER")) {
                            this.addChatMessage("YOUR LOBBY CHATTING HAS BEEN TEMPORARILY 'MUTED' BY THE ADMINS, TRY AGAIN LATER", "ADMIN_CHAT_CONTROL", false);
                            continue;
                        }
                        if (message.getMessage().equals("?YOUR CHATTING IN THIS GAME HAS BEEN 'MUTED' BY THE HOST")) {
                            this.addChatMessage("YOUR CHATTING IN THIS GAME HAS BEEN 'MUTED' BY THE HOST", "HOST_CHAT_CONTROL", false);
                            continue;
                        }
                    }
                    this.addChatMessage(message.getMessage(), message.getFrom(), message.isMeMessage());
                }
            }
        } else {
            this.m_send.setEnabled(false);
            this.m_text.setEnabled(false);
            this.updatePlayerList(Collections.<INode>emptyList());
        }
    }

    public Chat getChat() {
        return this.m_chat;
    }

    public void setShowTime(boolean showTime) {
        this.m_showTime = showTime;
    }

    private void layoutComponents() {
        ChatMessagePanel content = this;
        content.setLayout(new BorderLayout());
        this.m_scrollPane = new JScrollPane(this.m_text);
        content.add((Component)this.m_scrollPane, "Center");
        JPanel sendPanel = new JPanel();
        sendPanel.setLayout(new BorderLayout());
        sendPanel.add((Component)this.m_nextMessage, "Center");
        sendPanel.add((Component)this.m_send, "West");
        sendPanel.add((Component)this.m_setStatus, "East");
        content.add((Component)sendPanel, "South");
    }

    @Override
    public boolean requestFocusInWindow() {
        return this.m_nextMessage.requestFocusInWindow();
    }

    private void createComponents() {
        this.m_text = new JTextPane();
        this.m_text.setEditable(false);
        this.m_text.addMouseListener(new MouseListener(){

            public void mouseReleased(MouseEvent e) {
                String markedText = ChatMessagePanel.this.m_text.getSelectedText();
                if (markedText == null || markedText.length() == 0) {
                    ChatMessagePanel.this.m_nextMessage.requestFocusInWindow();
                }
            }

            public void mousePressed(MouseEvent e) {
            }

            public void mouseExited(MouseEvent e) {
            }

            public void mouseEntered(MouseEvent e) {
            }

            public void mouseClicked(MouseEvent e) {
            }
        });
        this.m_nextMessage = new JTextField(10);
        this.m_setStatus = new JButton(this.m_setStatusAction);
        this.m_setStatus.setFocusable(false);
        Insets inset = new Insets(3, 3, 3, 3);
        this.m_send = new JButton(this.m_sendAction);
        this.m_send.setMargin(inset);
        this.m_send.setFocusable(false);
    }

    private void setupKeyMap() {
        InputMap nextMessageKeymap = this.m_nextMessage.getInputMap();
        nextMessageKeymap.put(KeyStroke.getKeyStroke('\n'), this.m_sendAction);
        nextMessageKeymap.put(KeyStroke.getKeyStroke(38, 0, false), this.m_UpAction);
        nextMessageKeymap.put(KeyStroke.getKeyStroke(40, 0, false), this.m_DownAction);
    }

    private void cleanupKeyMap() {
        InputMap nextMessageKeymap = this.m_nextMessage.getInputMap();
        nextMessageKeymap.remove(KeyStroke.getKeyStroke('\n'));
        nextMessageKeymap.remove(KeyStroke.getKeyStroke(38, 0, false));
        nextMessageKeymap.remove(KeyStroke.getKeyStroke(40, 0, false));
    }

    @Override
    public void addMessage(String message, String from, boolean thirdperson) {
        this.addMessageWithSound(message, from, thirdperson, "message.wav");
    }

    @Override
    public void addMessageWithSound(final String message, final String from, final boolean thirdperson, final String sound) {
        Runnable runner = new Runnable(){

            public void run() {
                if (from.equals(ChatMessagePanel.this.m_chat.getServerNode().getName())) {
                    if (message.equals("?YOUR LOBBY CHATTING HAS BEEN TEMPORARILY 'MUTED' BY THE ADMINS, TRY AGAIN LATER")) {
                        ChatMessagePanel.this.addChatMessage("YOUR LOBBY CHATTING HAS BEEN TEMPORARILY 'MUTED' BY THE ADMINS, TRY AGAIN LATER", "ADMIN_CHAT_CONTROL", false);
                        return;
                    }
                    if (message.equals("?YOUR CHATTING IN THIS GAME HAS BEEN 'MUTED' BY THE HOST")) {
                        ChatMessagePanel.this.addChatMessage("YOUR CHATTING IN THIS GAME HAS BEEN 'MUTED' BY THE HOST", "HOST_CHAT_CONTROL", false);
                        return;
                    }
                }
                if (!ChatMessagePanel.this.floodControl.allow(from, System.currentTimeMillis())) {
                    if (from.equals(ChatMessagePanel.this.m_chat.getLocalNode().getName())) {
                        ChatMessagePanel.this.addChatMessage("MESSAGE LIMIT EXCEEDED, TRY AGAIN LATER", "ADMIN_FLOOD_CONTROL", false);
                    }
                    return;
                }
                ChatMessagePanel.this.addChatMessage(message, from, thirdperson);
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        BoundedRangeModel scrollModel = ChatMessagePanel.this.m_scrollPane.getVerticalScrollBar().getModel();
                        scrollModel.setValue(scrollModel.getMaximum());
                    }
                });
                ClipPlayer.play(sound);
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            runner.run();
        } else {
            SwingUtilities.invokeLater(runner);
        }
    }

    private void addChatMessage(String originalMessage, String from, boolean thirdperson) {
        String message = this.trimMessage(originalMessage);
        try {
            String time = this.simpleDateFormat.format(new Date());
            Document doc = this.m_text.getDocument();
            if (thirdperson) {
                doc.insertString(doc.getLength(), this.m_showTime ? "* " + time + " " + from : "* " + from, this.bold);
            } else {
                doc.insertString(doc.getLength(), this.m_showTime ? time + " " + from + ": " : from + ": ", this.bold);
            }
            doc.insertString(doc.getLength(), " " + message + "\n", this.normal);
            ChatMessagePanel.trimLines(doc, 5000);
        }
        catch (BadLocationException ble) {
            ble.printStackTrace();
        }
    }

    public void addServerMessage(String message) {
        try {
            Document doc = this.m_text.getDocument();
            doc.insertString(doc.getLength(), message + "\n", this.normal);
        }
        catch (BadLocationException ble) {
            ble.printStackTrace();
        }
    }

    @Override
    public void addStatusMessage(final String message) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                try {
                    Document doc = ChatMessagePanel.this.m_text.getDocument();
                    doc.insertString(doc.getLength(), message + "\n", ChatMessagePanel.this.italic);
                    ChatMessagePanel.trimLines(doc, 5000);
                }
                catch (BadLocationException ble) {
                    ble.printStackTrace();
                }
            }
        });
    }

    public static void trimLines(Document doc, int lineCount) {
        if (doc.getLength() < lineCount) {
            return;
        }
        try {
            String text = doc.getText(0, doc.getLength());
            int returnsFound = 0;
            for (int i = text.length() - 1; i >= 0; --i) {
                if (text.charAt(i) == '\n') {
                    ++returnsFound;
                }
                if (returnsFound != lineCount) continue;
                doc.remove(0, i);
                return;
            }
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
    }

    private String trimMessage(String originalMessage) {
        if (originalMessage.length() > 200) {
            return originalMessage.substring(0, 199) + "...";
        }
        return originalMessage;
    }

    @Override
    public void updatePlayerList(Collection<INode> players) {
    }
}

