/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.engine.chat;

import games.strategy.engine.chat.Chat;
import games.strategy.engine.chat.ChatMessagePanel;
import games.strategy.engine.chat.ChatPlayerPanel;
import games.strategy.engine.message.IChannelMessenger;
import games.strategy.engine.message.IRemoteMessenger;
import games.strategy.net.IMessenger;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JPanel;
import javax.swing.JSplitPane;

public class ChatPanel
extends JPanel {
    static int s_divider_size = 5;
    private ChatPlayerPanel m_chatPlayerPanel;
    private ChatMessagePanel m_chatMessagePanel;

    public ChatPanel(IMessenger messenger, IChannelMessenger channelMessenger, IRemoteMessenger remoteMessenger, String chatName) {
        this.init();
        Chat chat = new Chat(messenger, chatName, channelMessenger, remoteMessenger);
        this.setChat(chat);
    }

    public ChatPanel(Chat chat) {
        this.init();
        this.setChat(chat);
    }

    private void init() {
        this.createComponents();
        this.layoutComponents();
        this.setSize(300, 200);
    }

    public void setChat(Chat chat) {
        this.m_chatMessagePanel.setChat(chat);
        this.m_chatPlayerPanel.setChat(chat);
    }

    public Chat getChat() {
        return this.m_chatMessagePanel.getChat();
    }

    private void layoutComponents() {
        ChatPanel content = this;
        content.setLayout(new BorderLayout());
        JSplitPane split = new JSplitPane(1);
        split.setLeftComponent(this.m_chatMessagePanel);
        split.setRightComponent(this.m_chatPlayerPanel);
        split.setOneTouchExpandable(false);
        split.setDividerSize(s_divider_size);
        split.setResizeWeight(1.0);
        content.add((Component)split, "Center");
    }

    private void createComponents() {
        this.m_chatPlayerPanel = new ChatPlayerPanel(null);
        this.m_chatMessagePanel = new ChatMessagePanel(null);
    }

    public void setPlayerRenderer(DefaultListCellRenderer renderer) {
        this.m_chatPlayerPanel.setPlayerRenderer(renderer);
        this.m_chatMessagePanel.setPreferredSize(new Dimension(30, this.m_chatMessagePanel.getPreferredSize().height));
    }

    public void setShowChatTime(boolean showTime) {
        this.m_chatMessagePanel.setShowTime(showTime);
    }
}

