/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.engine.data;

import games.strategy.engine.data.Change;
import games.strategy.engine.data.GameData;
import games.strategy.engine.data.ProductionFrontier;
import games.strategy.engine.data.ProductionRule;
import games.strategy.engine.data.RemoveProductionRule;

class AddProductionRule
extends Change {
    private static final long serialVersionUID = 2583955907289570063L;
    private final ProductionRule m_rule;
    private final ProductionFrontier m_frontier;

    public AddProductionRule(ProductionRule rule, ProductionFrontier frontier) {
        if (rule == null) {
            throw new IllegalArgumentException("Null rule");
        }
        if (frontier == null) {
            throw new IllegalArgumentException("Null frontier");
        }
        this.m_rule = rule;
        this.m_frontier = frontier;
    }

    public void perform(GameData data) {
        this.m_frontier.addRule(this.m_rule);
    }

    public Change invert() {
        return new RemoveProductionRule(this.m_rule, this.m_frontier);
    }
}

