/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.engine.data;

import games.strategy.engine.data.Change;
import games.strategy.engine.data.GameData;
import games.strategy.engine.data.RemoveUnits;
import games.strategy.engine.data.Unit;
import games.strategy.engine.data.UnitCollection;
import games.strategy.engine.data.UnitHolder;
import java.util.ArrayList;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class AddUnits
extends Change {
    static final long serialVersionUID = 2694342784633196289L;
    private final String m_name;
    private final Collection<Unit> m_units;
    private final String m_type;

    AddUnits(UnitCollection collection, Collection<Unit> units) {
        this.m_units = new ArrayList<Unit>(units);
        this.m_name = collection.getHolder().getName();
        this.m_type = collection.getHolder().getType();
    }

    AddUnits(String name, String type, Collection<Unit> units) {
        this.m_units = new ArrayList<Unit>(units);
        this.m_type = type;
        this.m_name = name;
    }

    @Override
    public Change invert() {
        return new RemoveUnits(this.m_name, this.m_type, this.m_units);
    }

    @Override
    protected void perform(GameData data) {
        UnitHolder holder = data.getUnitHolder(this.m_name, this.m_type);
        holder.getUnits().addAllUnits(this.m_units);
    }

    public String toString() {
        return "Add unit change.  Add to:" + this.m_name + " units:" + this.m_units;
    }
}

