/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.engine.data;

import games.strategy.engine.data.GameData;
import games.strategy.engine.data.GameDataComponent;
import games.strategy.engine.data.PlayerID;
import games.strategy.engine.data.Territory;
import games.strategy.triplea.delegate.dataObjects.BattleRecords;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BattleRecordsList
extends GameDataComponent
implements Serializable {
    private static final long serialVersionUID = 7515693859612849475L;
    private Map<Integer, BattleRecords> m_battleRecords = new HashMap<Integer, BattleRecords>();

    public BattleRecordsList(GameData data) {
        super(data);
    }

    public static void addRecords(Map<Integer, BattleRecords> recordList, Integer currentRound, BattleRecords other) {
        BattleRecords current = recordList.get(currentRound);
        if (current == null) {
            recordList.put(currentRound, other);
            return;
        }
        current.addRecord(other);
        recordList.put(currentRound, current);
    }

    public void setRecords(Map<Integer, BattleRecords> recordList) {
        this.m_battleRecords = recordList;
    }

    public BattleRecords getCurrentRound() {
        return BattleRecordsList.copyList(this.m_battleRecords).get(this.getData().getSequence().getRound());
    }

    public Map<Integer, BattleRecords> getBattleRecordsMap() {
        return BattleRecordsList.copyList(this.m_battleRecords);
    }

    private static Map<Integer, BattleRecords> copyList(Map<Integer, BattleRecords> records) {
        HashMap<Integer, BattleRecords> copy = new HashMap<Integer, BattleRecords>();
        for (Map.Entry<Integer, BattleRecords> entry : records.entrySet()) {
            copy.put((int)entry.getKey(), new BattleRecords(entry.getValue()));
        }
        return copy;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("BattleRecordsList:");
        for (Map.Entry<Integer, BattleRecords> entry : this.m_battleRecords.entrySet()) {
            sb.append("\n");
            sb.append(entry.getKey().toString());
            sb.append(" -> ");
            sb.append(entry.getValue().toString());
            sb.append("");
        }
        return sb.toString();
    }

    public static int getTUVdamageCausedByPlayer(PlayerID attacker, BattleRecordsList brl, int beginningRound, int endRound, boolean currentRoundOnly, boolean includeNullPlayer) {
        int damageCausedByAttacker = 0;
        ArrayList<BattleRecords> brs = new ArrayList<BattleRecords>();
        if (currentRoundOnly) {
            if (brl != null && brl.getCurrentRound() != null) {
                brs.add(brl.getCurrentRound());
            }
        } else {
            Map<Integer, BattleRecords> currentList = brl.getBattleRecordsMap();
            for (int i = beginningRound; i > endRound; ++i) {
                BattleRecords currentRecords = currentList.get(i);
                if (currentRecords == null) continue;
                brs.add(currentRecords);
            }
        }
        for (BattleRecords br : brs) {
            damageCausedByAttacker += BattleRecords.getLostTUVforBattleRecords(BattleRecords.getRecordsForPlayerID(attacker, br), false, includeNullPlayer);
        }
        return damageCausedByAttacker;
    }

    public static boolean getWereThereBattlesInTerritoriesMatching(PlayerID attacker, PlayerID defender, String battleType, Collection<Territory> anyOfTheseTerritories, BattleRecordsList brl, int beginningRound, int endRound, boolean currentRoundOnly) {
        ArrayList<BattleRecords> brs = new ArrayList<BattleRecords>();
        if (currentRoundOnly) {
            if (brl != null && brl.getCurrentRound() != null) {
                brs.add(brl.getCurrentRound());
            }
        } else {
            Map<Integer, BattleRecords> currentList = brl.getBattleRecordsMap();
            for (int i = beginningRound; i > endRound; ++i) {
                BattleRecords currentRecords = currentList.get(i);
                if (currentRecords == null) continue;
                brs.add(currentRecords);
            }
        }
        for (BattleRecords br : brs) {
            if (!BattleRecords.getWereThereBattlesInTerritoriesMatching(attacker == null ? BattleRecords.getAllRecords(br) : BattleRecords.getRecordsForPlayerID(attacker, br), attacker, defender, battleType, anyOfTheseTerritories)) continue;
            return true;
        }
        return false;
    }
}

