/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.engine.data;

import games.strategy.engine.data.Attachable;
import games.strategy.engine.data.GameData;
import games.strategy.engine.data.GameParseException;
import games.strategy.engine.data.IAttachment;
import games.strategy.engine.data.annotations.InternalDoNotExport;
import games.strategy.util.PropertyUtil;

public abstract class DefaultAttachment
implements IAttachment {
    @InternalDoNotExport
    private GameData m_data;
    @InternalDoNotExport
    private Attachable m_attachedTo;
    @InternalDoNotExport
    private String m_name;

    protected DefaultAttachment(String name, Attachable attachable, GameData gameData) {
        this.setName(name);
        this.setData(gameData);
        this.setAttachedTo(attachable);
    }

    public abstract void validate(GameData var1) throws GameParseException;

    protected static int getInt(String aString) {
        try {
            return Integer.parseInt(aString);
        }
        catch (NumberFormatException nfe) {
            throw new IllegalArgumentException("Attachments: " + aString + " is not a valid int value");
        }
    }

    protected static boolean getBool(String value) {
        if (value.equalsIgnoreCase("true")) {
            return true;
        }
        if (value.equalsIgnoreCase("false")) {
            return false;
        }
        throw new IllegalArgumentException("Attachments: " + value + " is not a valid boolean");
    }

    protected static IllegalArgumentException getSetterExceptionMessage(DefaultAttachment failingObject, String propertyName, String givenValue, String ... allowedValues) {
        StringBuilder rVal = new StringBuilder();
        rVal.append(failingObject.getClass().getName() + ": " + failingObject.getName() + ": property " + propertyName + " must be either ");
        rVal.append(allowedValues[0]);
        for (int i = 1; i < allowedValues.length; ++i) {
            rVal.append(" or " + allowedValues[i]);
        }
        return new IllegalArgumentException(rVal.toString() + " ([Not Allowed] Given: " + givenValue + ")");
    }

    protected String thisErrorMsg() {
        return "   for: " + this.toString();
    }

    public String getRawPropertyString(String property) {
        return PropertyUtil.getPropertyFieldObject(property, this).toString();
    }

    public Object getRawPropertyObject(String property) {
        return PropertyUtil.getPropertyFieldObject(property, this);
    }

    @InternalDoNotExport
    public void setData(GameData data) {
        this.m_data = data;
    }

    protected GameData getData() {
        return this.m_data;
    }

    public Attachable getAttachedTo() {
        return this.m_attachedTo;
    }

    @InternalDoNotExport
    public void setAttachedTo(Attachable attachable) {
        this.m_attachedTo = attachable;
    }

    public String getName() {
        return this.m_name;
    }

    @InternalDoNotExport
    public void setName(String aString) {
        this.m_name = aString;
    }

    public String toString() {
        return this.getClass().getSimpleName() + " attached to:" + this.m_attachedTo + " with name:" + this.m_name;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DefaultAttachment other = (DefaultAttachment)obj;
        if (this.m_attachedTo == null ? other.m_attachedTo != null : !this.m_attachedTo.toString().equals(other.m_attachedTo.toString())) {
            return false;
        }
        if (this.m_name == null ? other.m_name != null : !this.m_name.equals(other.m_name)) {
            return false;
        }
        return this.toString().equals(other.toString());
    }
}

