/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.engine.data;

import games.strategy.engine.data.GameData;
import games.strategy.engine.data.GameDataComponent;
import games.strategy.engine.data.PlayerID;
import games.strategy.engine.delegate.IDelegate;
import java.util.Properties;

public class GameStep
extends GameDataComponent {
    private final String m_name;
    private final String m_displayName;
    private final PlayerID m_player;
    private final String m_delegate;
    private int m_hashCode = -1;
    private int m_runCount = 0;
    private int m_maxRunCount = -1;
    private final Properties m_properties;

    public GameStep(String name, String displayName, PlayerID player, IDelegate delegate, GameData data, Properties stepProperties) {
        super(data);
        this.m_name = name;
        this.m_displayName = displayName;
        this.m_player = player;
        this.m_delegate = delegate.getName();
        this.m_properties = stepProperties;
    }

    public String getName() {
        return this.m_name;
    }

    public PlayerID getPlayerID() {
        return this.m_player;
    }

    public IDelegate getDelegate() {
        return this.getData().getDelegateList().getDelegate(this.m_delegate);
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof GameStep)) {
            return false;
        }
        GameStep other = (GameStep)o;
        return other.m_name.equals(this.m_name) && other.m_delegate.equals(this.m_delegate) && other.m_player.equals(this.m_player);
    }

    public boolean hasReachedMaxRunCount() {
        if (this.m_maxRunCount == -1) {
            return false;
        }
        return this.m_maxRunCount <= this.m_runCount;
    }

    public int getRunCount() {
        return this.m_runCount;
    }

    public void incrementRunCount() {
        ++this.m_runCount;
    }

    public void setMaxRunCount(int count) {
        this.m_maxRunCount = count;
    }

    public int getMaxRunCount() {
        return this.m_maxRunCount;
    }

    public int hashCode() {
        if (this.m_hashCode == -1) {
            String s = this.m_name + this.m_delegate + this.m_player;
            this.m_hashCode = s.hashCode();
        }
        return this.m_hashCode;
    }

    public String getDisplayName() {
        if (this.m_displayName == null) {
            return this.getDelegate().getDisplayName();
        }
        return this.m_displayName;
    }

    public Properties getProperties() {
        return this.m_properties;
    }
}

