/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.engine.data;

import games.strategy.engine.data.Change;
import games.strategy.engine.data.GameData;
import games.strategy.engine.data.PlayerID;
import games.strategy.engine.data.Territory;

class OwnerChange
extends Change {
    static final long serialVersionUID = -5938125380623744929L;
    private final String m_old;
    private final String m_new;
    private final String m_territory;

    OwnerChange(Territory territory, PlayerID newOwner) {
        this.m_territory = territory.getName();
        this.m_new = this.getName(newOwner);
        this.m_old = this.getName(territory.getOwner());
    }

    private OwnerChange(String name, String newOwner, String oldOwner) {
        this.m_territory = name;
        this.m_new = newOwner;
        this.m_old = oldOwner;
    }

    private String getName(PlayerID player) {
        if (player == null) {
            return null;
        }
        return player.getName();
    }

    private PlayerID getPlayerID(String name, GameData data) {
        if (name == null) {
            return null;
        }
        return data.getPlayerList().getPlayerID(name);
    }

    public Change invert() {
        return new OwnerChange(this.m_territory, this.m_old, this.m_new);
    }

    protected void perform(GameData data) {
        data.getMap().getTerritory(this.m_territory).setOwner(this.getPlayerID(this.m_new, data));
    }

    public String toString() {
        return this.m_new + " takes " + this.m_territory + " from " + this.m_old;
    }
}

