/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.engine.data;

import games.strategy.engine.data.Change;
import games.strategy.engine.data.GameData;
import games.strategy.engine.data.PlayerID;
import games.strategy.engine.data.RelationshipType;
import games.strategy.engine.data.Territory;
import games.strategy.triplea.delegate.Matches;
import games.strategy.util.CompositeMatchAnd;
import games.strategy.util.Match;

class RelationshipChange
extends Change {
    private static final long serialVersionUID = 2694339584633196289L;
    private final String m_player1;
    private final String m_player2;
    private final String m_OldRelation;
    private final String m_NewRelation;

    RelationshipChange(PlayerID player1, PlayerID player2, RelationshipType oldRelation, RelationshipType newRelation) {
        this.m_player1 = player1.getName();
        this.m_player2 = player2.getName();
        this.m_OldRelation = oldRelation.getName();
        this.m_NewRelation = newRelation.getName();
    }

    private RelationshipChange(String player1, String player2, String oldRelation, String newRelation) {
        this.m_player1 = player1;
        this.m_player2 = player2;
        this.m_OldRelation = oldRelation;
        this.m_NewRelation = newRelation;
    }

    public Change invert() {
        return new RelationshipChange(this.m_player1, this.m_player2, this.m_NewRelation, this.m_OldRelation);
    }

    protected void perform(GameData data) {
        data.getRelationshipTracker().setRelationship(data.getPlayerList().getPlayerID(this.m_player1), data.getPlayerList().getPlayerID(this.m_player2), data.getRelationshipTypeList().getRelationshipType(this.m_NewRelation));
        if (Matches.RelationshipTypeIsAtWar.match(data.getRelationshipTypeList().getRelationshipType(this.m_NewRelation))) {
            for (Territory t : Match.getMatches(data.getMap().getTerritories(), new CompositeMatchAnd(Matches.territoryHasUnitsOwnedBy(data.getPlayerList().getPlayerID(this.m_player1)), Matches.territoryHasUnitsOwnedBy(data.getPlayerList().getPlayerID(this.m_player2))))) {
                t.notifyChanged();
            }
        }
    }

    public String toString() {
        return "Add relation change. " + this.m_player1 + " and " + this.m_player2 + " change from " + this.m_OldRelation + " to " + this.m_NewRelation;
    }
}

