/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.engine.data;

import games.strategy.engine.data.GameData;
import games.strategy.engine.data.GameDataComponent;
import games.strategy.engine.data.GameParseException;
import games.strategy.engine.data.RelationshipType;
import games.strategy.triplea.attatchments.RelationshipTypeAttachment;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RelationshipTypeList
extends GameDataComponent
implements Iterable<RelationshipType> {
    private static final long serialVersionUID = 6590541694575435151L;
    private final HashMap<String, RelationshipType> m_relationshipTypes = new HashMap();

    public RelationshipType getSelfRelation() {
        return this.getRelationshipType("self_relation");
    }

    public RelationshipType getNullRelation() {
        return this.getRelationshipType("null_relation");
    }

    protected RelationshipTypeList(GameData data) {
        super(data);
        try {
            this.createDefaultRelationship("self_relation", "allied", data);
            this.createDefaultRelationship("null_relation", "war", data);
            this.createDefaultRelationship("default_war_relation", "war", data);
            this.createDefaultRelationship("default_allied_relation", "allied", data);
        }
        catch (GameParseException e) {
            throw new IllegalStateException(e);
        }
    }

    private void createDefaultRelationship(String relationshipTypeConstant, String relationshipArcheType, GameData data) throws GameParseException {
        RelationshipType relationshipType = new RelationshipType(relationshipTypeConstant, data);
        RelationshipTypeAttachment at = new RelationshipTypeAttachment("relationshipTypeAttachment", relationshipType, data);
        at.setArcheType(relationshipArcheType);
        relationshipType.addAttachment("relationshipTypeAttachment", at);
        this.addRelationshipType(relationshipType);
    }

    protected RelationshipType addRelationshipType(RelationshipType p) {
        this.m_relationshipTypes.put(p.getName(), p);
        return p;
    }

    public RelationshipType getRelationshipType(String name) {
        return this.m_relationshipTypes.get(name);
    }

    @Override
    public Iterator<RelationshipType> iterator() {
        return this.m_relationshipTypes.values().iterator();
    }

    public int size() {
        return this.m_relationshipTypes.size();
    }

    public RelationshipType getDefaultAlliedRelationship() {
        return this.getRelationshipType("default_allied_relation");
    }

    public RelationshipType getDefaultWarRelationship() {
        return this.getRelationshipType("default_war_relation");
    }

    public Collection<RelationshipType> getAllRelationshipTypes() {
        return this.m_relationshipTypes.values();
    }
}

