/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.engine.data;

import games.strategy.engine.data.AddAttachmentChange;
import games.strategy.engine.data.Attachable;
import games.strategy.engine.data.Change;
import games.strategy.engine.data.GameData;
import games.strategy.engine.data.IAttachment;

class RemoveAttachmentChange
extends Change {
    private static final long serialVersionUID = 6365648682759047674L;
    private final IAttachment m_attachment;
    private final String m_originalAttachmentName;
    private final Attachable m_originalAttachable;
    private final Attachable m_attachable;
    private final String m_name;

    public RemoveAttachmentChange(IAttachment attachment, Attachable attachable, String name) {
        this.m_attachment = attachment;
        this.m_originalAttachmentName = attachment.getName();
        this.m_originalAttachable = attachment.getAttachedTo();
        this.m_attachable = attachable;
        this.m_name = name;
    }

    protected void perform(GameData data) {
        this.m_attachable.getAttachments().remove(this.m_name);
        this.m_attachment.setAttachedTo(null);
    }

    public Change invert() {
        return new AddAttachmentChange(this.m_attachment, this.m_originalAttachable, this.m_originalAttachmentName);
    }
}

