/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.engine.data;

import games.strategy.engine.data.DefaultNamed;
import games.strategy.engine.data.GameData;
import games.strategy.engine.data.NamedAttachable;
import games.strategy.engine.data.Resource;
import games.strategy.engine.data.UnitType;
import games.strategy.util.IntegerMap;
import java.io.Serializable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RepairRule
extends DefaultNamed
implements Serializable {
    private final IntegerMap<Resource> m_cost = new IntegerMap();
    private final IntegerMap<NamedAttachable> m_results = new IntegerMap();

    public RepairRule(String name, GameData data) {
        super(name, data);
    }

    protected void addCost(Resource resource, int quantity) {
        this.m_cost.put(resource, quantity);
    }

    protected void addResult(NamedAttachable obj, int quantity) {
        if (!(obj instanceof UnitType) && !(obj instanceof Resource)) {
            throw new IllegalArgumentException("results must be units or resources, not:" + obj.getClass().getName());
        }
        this.m_results.put(obj, quantity);
    }

    public IntegerMap<Resource> getCosts() {
        return this.m_cost.copy();
    }

    public IntegerMap<NamedAttachable> getResults() {
        return this.m_results;
    }

    @Override
    public String toString() {
        return "RepairRule:" + this.getName();
    }
}

