/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.engine.data;

import games.strategy.engine.data.GameData;
import games.strategy.engine.data.GameDataComponent;
import games.strategy.engine.data.PlayerID;
import games.strategy.engine.data.Territory;
import games.strategy.engine.data.UnitType;
import games.strategy.engine.data.annotations.GameProperty;
import games.strategy.net.GUID;
import java.io.Serializable;

public class Unit
extends GameDataComponent
implements Serializable {
    private PlayerID m_owner;
    private final GUID m_uid;
    private int m_hits = 0;
    private final int m_hitPoints = 1;
    private final UnitType m_type;

    protected Unit(UnitType type, PlayerID owner, GameData data) {
        super(data);
        if (type == null) {
            throw new IllegalArgumentException();
        }
        this.m_type = type;
        this.m_uid = new GUID();
        this.setOwner(owner);
    }

    public GUID getID() {
        return this.m_uid;
    }

    public UnitType getType() {
        return this.m_type;
    }

    public UnitType getUnitType() {
        return this.m_type;
    }

    public PlayerID getOwner() {
        return this.m_owner;
    }

    public Territory getTerritoryUnitIsIn() {
        for (Territory t : this.getData().getMap().getTerritories()) {
            if (!t.getUnits().getUnits().contains(this)) continue;
            return t;
        }
        return null;
    }

    public int getHits() {
        return this.m_hits;
    }

    @GameProperty(xmlProperty=false, gameProperty=true, adds=false)
    void setHits(int hits) {
        this.m_hits = hits;
    }

    @GameProperty(xmlProperty=false, gameProperty=true, adds=false)
    void setOwner(PlayerID player) {
        if (player == null) {
            player = PlayerID.NULL_PLAYERID;
        }
        this.m_owner = player;
    }

    public boolean equals(Object o) {
        if (!(o instanceof Unit)) {
            return false;
        }
        Unit other = (Unit)o;
        return this.m_uid.equals(other.m_uid);
    }

    public int hashCode() {
        return this.m_uid.hashCode();
    }

    public String toString() {
        return this.m_type.getName() + " owned by " + this.m_owner.getName();
    }

    public String toStringNoOwner() {
        return this.m_type.getName();
    }
}

