/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.engine.data;

import games.strategy.engine.data.GameData;
import games.strategy.engine.data.GameDataComponent;
import games.strategy.engine.data.NamedUnitHolder;
import games.strategy.engine.data.PlayerID;
import games.strategy.engine.data.Unit;
import games.strategy.engine.data.UnitType;
import games.strategy.util.IntegerMap;
import games.strategy.util.Match;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnitCollection
extends GameDataComponent
implements Iterable<Unit> {
    private final List<Unit> m_units = new ArrayList<Unit>();
    private final NamedUnitHolder m_holder;

    public UnitCollection(NamedUnitHolder holder, GameData data) {
        super(data);
        this.m_holder = holder;
    }

    void addUnit(Unit unit) {
        this.m_units.add(unit);
        this.m_holder.notifyChanged();
    }

    void addAllUnits(UnitCollection collection) {
        this.m_units.addAll(collection.m_units);
        this.m_holder.notifyChanged();
    }

    void addAllUnits(Collection<Unit> units) {
        this.m_units.addAll(units);
        this.m_holder.notifyChanged();
    }

    void removeAllUnits(Collection<Unit> units) {
        this.m_units.removeAll(units);
        this.m_holder.notifyChanged();
    }

    public int getUnitCount() {
        return this.m_units.size();
    }

    public int getUnitCount(UnitType type) {
        int count = 0;
        Iterator<Unit> iterator = this.m_units.iterator();
        while (iterator.hasNext()) {
            if (!iterator.next().getType().equals(type)) continue;
            ++count;
        }
        return count;
    }

    public int getUnitCount(UnitType type, PlayerID owner) {
        int count = 0;
        for (Unit current : this.m_units) {
            if (!current.getType().equals(type) || !current.getOwner().equals(owner)) continue;
            ++count;
        }
        return count;
    }

    public int getUnitCount(PlayerID owner) {
        int count = 0;
        Iterator<Unit> iterator = this.m_units.iterator();
        while (iterator.hasNext()) {
            if (!iterator.next().getOwner().equals(owner)) continue;
            ++count;
        }
        return count;
    }

    public boolean containsAll(Collection<Unit> units) {
        if (this.m_units.size() > 500 && units.size() > 500) {
            return new HashSet<Unit>(this.m_units).containsAll(units);
        }
        return this.m_units.containsAll(units);
    }

    public Collection<Unit> getUnits(UnitType type, int max_units) {
        if (max_units == 0) {
            return new ArrayList<Unit>();
        }
        if (max_units < 0) {
            throw new IllegalArgumentException("value must be positiive.  Instead its:" + max_units);
        }
        ArrayList<Unit> rVal = new ArrayList<Unit>();
        for (Unit current : this.m_units) {
            if (!current.getType().equals(type)) continue;
            rVal.add(current);
            if (rVal.size() != max_units) continue;
            return rVal;
        }
        return rVal;
    }

    public IntegerMap<UnitType> getUnitsByType() {
        IntegerMap<UnitType> units = new IntegerMap<UnitType>();
        for (UnitType type : this.getData().getUnitTypeList()) {
            int count = this.getUnitCount(type);
            if (count <= 0) continue;
            units.put(type, count);
        }
        return units;
    }

    public IntegerMap<UnitType> getUnitsByType(PlayerID id) {
        IntegerMap<UnitType> count = new IntegerMap<UnitType>();
        for (Unit unit : this.m_units) {
            if (!unit.getOwner().equals(id)) continue;
            count.add(unit.getType(), 1);
        }
        return count;
    }

    public Collection<Unit> getUnits(IntegerMap<UnitType> types) {
        ArrayList<Unit> units = new ArrayList<Unit>();
        for (UnitType type : types.keySet()) {
            units.addAll(this.getUnits(type, types.getInt(type)));
        }
        return units;
    }

    public int size() {
        return this.m_units.size();
    }

    public boolean isEmpty() {
        return this.m_units.isEmpty();
    }

    public Collection<Unit> getUnits() {
        return new ArrayList<Unit>(this.m_units);
    }

    public Set<PlayerID> getPlayersWithUnits() {
        HashSet<PlayerID> ids = new HashSet<PlayerID>();
        for (Unit unit : this.m_units) {
            ids.add(unit.getOwner());
        }
        return ids;
    }

    public IntegerMap<PlayerID> getPlayerUnitCounts() {
        IntegerMap<PlayerID> count = new IntegerMap<PlayerID>();
        for (Unit unit : this.m_units) {
            count.add(unit.getOwner(), 1);
        }
        return count;
    }

    public boolean hasUnitsFromMultiplePlayers() {
        return this.getPlayersWithUnits().size() > 1;
    }

    public NamedUnitHolder getHolder() {
        return this.m_holder;
    }

    public boolean allMatch(Match<Unit> matcher) {
        for (Unit unit : this.m_units) {
            if (matcher.match(unit)) continue;
            return false;
        }
        return true;
    }

    public boolean someMatch(Match<Unit> matcher) {
        for (Unit unit : this.m_units) {
            if (!matcher.match(unit)) continue;
            return true;
        }
        return false;
    }

    public int countMatches(Match<Unit> predicate) {
        return Match.countMatches(this.m_units, predicate);
    }

    public List<Unit> getMatches(Match<Unit> predicate) {
        ArrayList<Unit> values = new ArrayList<Unit>();
        for (Unit unit : this.m_units) {
            if (!predicate.match(unit)) continue;
            values.add(unit);
        }
        return values;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("Unit collecion held by ").append(this.m_holder.getName());
        buf.append(" units:");
        IntegerMap<UnitType> units = this.getUnitsByType();
        for (UnitType unit : units.keySet()) {
            buf.append(" <").append(unit.getName()).append(",").append(units.getInt(unit)).append("> ");
        }
        return buf.toString();
    }

    @Override
    public Iterator<Unit> iterator() {
        return Collections.unmodifiableList(this.m_units).iterator();
    }
}

