/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.engine.data;

import games.strategy.engine.data.Change;
import games.strategy.engine.data.GameData;
import games.strategy.engine.data.Territory;
import games.strategy.engine.data.Unit;
import games.strategy.util.IntegerMap;
import games.strategy.util.Util;
import java.util.Collection;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnitHitsChange
extends Change {
    private final IntegerMap<Unit> m_hits;
    private final IntegerMap<Unit> m_undoHits;

    private UnitHitsChange(IntegerMap<Unit> hits, IntegerMap<Unit> undoHits) {
        this.m_hits = hits;
        this.m_undoHits = undoHits;
    }

    public Collection<Unit> getUnits() {
        return this.m_hits.keySet();
    }

    UnitHitsChange(IntegerMap<Unit> hits) {
        this.m_hits = hits.copy();
        this.m_undoHits = new IntegerMap();
        for (Unit item : this.m_hits.keySet()) {
            this.m_undoHits.put(item, item.getHits());
        }
    }

    @Override
    protected void perform(GameData data) {
        for (Unit item : this.m_hits.keySet()) {
            item.setHits(this.m_hits.getInt(item));
        }
        Set<Unit> units = this.m_hits.keySet();
        for (Territory element : data.getMap().getTerritories()) {
            if (!Util.someIntersect(element.getUnits().getUnits(), units)) continue;
            element.notifyChanged();
        }
    }

    @Override
    public Change invert() {
        return new UnitHitsChange(this.m_undoHits, this.m_hits);
    }
}

