/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.engine.data.properties;

import games.strategy.engine.data.GameData;
import games.strategy.engine.data.GameDataComponent;
import games.strategy.engine.data.properties.IEditableProperty;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GameProperties
extends GameDataComponent {
    private final Map<String, Object> m_constantProperties = new HashMap<String, Object>();
    private final Map<String, IEditableProperty> m_editableProperties = new HashMap<String, IEditableProperty>();
    private final List<String> m_ordering = new ArrayList<String>();

    public GameProperties(GameData data) {
        super(data);
    }

    public void set(String key, Object value) {
        if (value == null) {
            this.m_constantProperties.remove(key);
            this.m_ordering.remove(key);
        } else {
            this.m_constantProperties.put(key, value);
            this.m_ordering.add(key);
        }
    }

    public Object get(String key) {
        if (this.m_editableProperties.containsKey(key)) {
            return this.m_editableProperties.get(key).getValue();
        }
        return this.m_constantProperties.get(key);
    }

    public boolean get(String key, boolean defaultValue) {
        Object value = this.get(key);
        if (value == null) {
            return defaultValue;
        }
        return (Boolean)value;
    }

    public int get(String key, int defaultValue) {
        Object value = this.get(key);
        if (value == null) {
            return defaultValue;
        }
        return (Integer)value;
    }

    public String get(String key, String defaultValue) {
        Object value = this.get(key);
        if (value == null) {
            return defaultValue;
        }
        return (String)value;
    }

    public Object get(String key, Object defaultValue) {
        Object value = this.get(key);
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    public void addEditableProperty(IEditableProperty property) {
        this.m_editableProperties.put(property.getName(), property);
        this.m_ordering.add(property.getName());
    }

    public List<IEditableProperty> getEditableProperties() {
        ArrayList<IEditableProperty> properties = new ArrayList<IEditableProperty>();
        for (String propertyName : this.m_ordering) {
            if (!this.m_editableProperties.containsKey(propertyName)) continue;
            properties.add(this.m_editableProperties.get(propertyName));
        }
        return properties;
    }
}

