/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.engine.delegate;

import games.strategy.engine.GameOverException;
import games.strategy.engine.message.MessengerException;
import games.strategy.triplea.util.WrappedInvocationHandler;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DelegateExecutionManager {
    private final Logger sm_logger = Logger.getLogger(DelegateExecutionManager.class.getName());
    private final ReentrantReadWriteLock m_readWriteLock = new ReentrantReadWriteLock();
    private final ThreadLocal<Boolean> m_currentThreadHasReadLock = new ThreadLocal();
    private volatile boolean m_isGameOver = false;

    public void setGameOver() {
        this.m_isGameOver = true;
    }

    public boolean blockDelegateExecution(int timeToWaitMS) throws InterruptedException {
        boolean rVal = this.m_readWriteLock.writeLock().tryLock(timeToWaitMS, TimeUnit.MILLISECONDS);
        if (rVal && this.sm_logger.isLoggable(Level.FINE)) {
            this.sm_logger.fine(Thread.currentThread().getName() + " block delegate execution.");
        }
        return rVal;
    }

    public void resumeDelegateExecution() {
        if (this.sm_logger.isLoggable(Level.FINE)) {
            this.sm_logger.fine(Thread.currentThread().getName() + " resumes delegate execution.");
        }
        this.m_readWriteLock.writeLock().unlock();
    }

    private boolean currentThreadHasReadLock() {
        return this.m_currentThreadHasReadLock.get() == Boolean.TRUE;
    }

    public Object createOutboundImplementation(final Object implementor, Class<?>[] interfaces) {
        this.assertGameNotOver();
        InvocationHandler ih = new InvocationHandler(){

            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                DelegateExecutionManager.this.assertGameNotOver();
                boolean threadLocks = DelegateExecutionManager.this.currentThreadHasReadLock();
                if (threadLocks) {
                    DelegateExecutionManager.this.leaveDelegateExecution();
                }
                try {
                    Object object = method.invoke(implementor, args);
                    return object;
                }
                catch (MessengerException me) {
                    throw new GameOverException("Game Over");
                }
                catch (InvocationTargetException ite) {
                    DelegateExecutionManager.this.assertGameNotOver();
                    throw ite;
                }
                finally {
                    if (threadLocks) {
                        DelegateExecutionManager.this.enterDelegateExecution();
                    }
                }
            }
        };
        return Proxy.newProxyInstance(implementor.getClass().getClassLoader(), interfaces, ih);
    }

    private void assertGameNotOver() {
        if (this.m_isGameOver) {
            throw new GameOverException("Game Over");
        }
    }

    public Object createInboundImplementation(final Object implementor, Class<?>[] interfaces) {
        this.assertGameNotOver();
        WrappedInvocationHandler ih = new WrappedInvocationHandler(implementor){

            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                if (super.shouldHandle(method, args)) {
                    return super.handle(method, args);
                }
                DelegateExecutionManager.this.assertGameNotOver();
                DelegateExecutionManager.this.enterDelegateExecution();
                try {
                    Object object = method.invoke(implementor, args);
                    return object;
                }
                catch (InvocationTargetException ite) {
                    DelegateExecutionManager.this.assertGameNotOver();
                    throw ite.getCause();
                }
                catch (RuntimeException re) {
                    DelegateExecutionManager.this.assertGameNotOver();
                    throw re;
                }
                finally {
                    DelegateExecutionManager.this.leaveDelegateExecution();
                }
            }
        };
        return Proxy.newProxyInstance(implementor.getClass().getClassLoader(), interfaces, (InvocationHandler)ih);
    }

    public void leaveDelegateExecution() {
        if (this.sm_logger.isLoggable(Level.FINE)) {
            this.sm_logger.fine(Thread.currentThread().getName() + " leaves delegate execution.");
        }
        this.m_readWriteLock.readLock().unlock();
        this.m_currentThreadHasReadLock.set(null);
    }

    public void enterDelegateExecution() {
        if (this.sm_logger.isLoggable(Level.FINE)) {
            this.sm_logger.fine(Thread.currentThread().getName() + " enters delegate execution.");
        }
        if (this.currentThreadHasReadLock()) {
            throw new IllegalStateException("Already locked?");
        }
        this.m_readWriteLock.readLock().lock();
        this.m_currentThreadHasReadLock.set(Boolean.TRUE);
    }
}

