/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.engine.framework;

import games.strategy.engine.EngineVersion;
import games.strategy.engine.data.GameData;
import games.strategy.engine.delegate.IDelegate;
import games.strategy.engine.framework.GameRunner;
import games.strategy.util.Version;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Iterator;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class GameDataManager {
    private static final String DELEGATE_START = "<DelegateStart>";
    private static final String DELEGATE_DATA_NEXT = "<DelegateData>";
    private static final String DELEGATE_LIST_END = "<EndDelegateList>";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GameData loadGame(File savedGameFile) throws IOException {
        InputStream input = null;
        try {
            input = new BufferedInputStream(new FileInputStream(savedGameFile));
            GameData gameData = this.loadGame(input);
            return gameData;
        }
        finally {
            try {
                if (input != null) {
                    input.close();
                }
            }
            catch (Exception e) {}
        }
    }

    public GameData loadGame(InputStream input) throws IOException {
        return this.loadGame(new ObjectInputStream(new GZIPInputStream(input)));
    }

    public GameData loadGame(ObjectInputStream input) throws IOException {
        try {
            Version readVersion = (Version)input.readObject();
            if (!readVersion.equals(EngineVersion.VERSION)) {
                if (GameRunner.areWeOldExtraJar()) {
                    throw new IOException("<html>Please run the default TripleA and try to open this game again. <br>This TripleA engine is old and kept only for backwards compatibility and can only open savegames created by engines with these first 3 version digits: " + EngineVersion.VERSION.toStringFull("_", true) + "</html>");
                }
                throw new IOException("Incompatible engine versions. We are: " + EngineVersion.VERSION + " . Trying to load game created with: " + readVersion);
            }
            GameData data = (GameData)input.readObject();
            this.loadDelegates(input, data);
            data.postDeSerialize();
            return data;
        }
        catch (ClassNotFoundException cnfe) {
            throw new IOException(cnfe.getMessage());
        }
    }

    private void loadDelegates(ObjectInputStream input, GameData data) throws ClassNotFoundException, IOException {
        Object endMarker = input.readObject();
        while (!endMarker.equals(DELEGATE_LIST_END)) {
            IDelegate instance;
            String name = (String)input.readObject();
            String displayName = (String)input.readObject();
            String className = (String)input.readObject();
            try {
                instance = (IDelegate)Class.forName(className).newInstance();
                instance.initialize(name, displayName);
                data.getDelegateList().addDelegate(instance);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new IOException(e.getMessage());
            }
            String next = (String)input.readObject();
            if (next.equals(DELEGATE_DATA_NEXT)) {
                instance.loadState((Serializable)input.readObject());
            }
            endMarker = input.readObject();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveGame(File destination, GameData data) throws IOException {
        FilterOutputStream out = null;
        try {
            FileOutputStream fileStream = new FileOutputStream(destination);
            out = new BufferedOutputStream(fileStream);
            this.saveGame(fileStream, data);
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void saveGame(OutputStream sink, GameData data) throws IOException {
        this.saveGame(sink, data, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveGame(OutputStream sink, GameData data, boolean saveDelegateInfo) throws IOException {
        ByteArrayOutputStream bytes = new ByteArrayOutputStream(25000);
        ObjectOutputStream outStream = new ObjectOutputStream(bytes);
        outStream.writeObject(EngineVersion.VERSION);
        data.acquireReadLock();
        try {
            outStream.writeObject(data);
            if (saveDelegateInfo) {
                this.writeDelegates(data, outStream);
            } else {
                outStream.writeObject(DELEGATE_LIST_END);
            }
        }
        finally {
            data.releaseReadLock();
        }
        GZIPOutputStream zippedOut = new GZIPOutputStream(sink);
        zippedOut.write(bytes.toByteArray());
        zippedOut.flush();
        zippedOut.close();
    }

    private void writeDelegates(GameData data, ObjectOutputStream out) throws IOException {
        Iterator<IDelegate> iter = data.getDelegateList().iterator();
        while (iter.hasNext()) {
            out.writeObject(DELEGATE_START);
            IDelegate delegate = iter.next();
            out.writeObject(delegate.getName());
            out.writeObject(delegate.getDisplayName());
            out.writeObject(delegate.getClass().getName());
            out.writeObject(DELEGATE_DATA_NEXT);
            out.writeObject(delegate.saveState());
        }
        out.writeObject(DELEGATE_LIST_END);
    }
}

