/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.engine.framework;

import games.strategy.engine.EngineVersion;
import games.strategy.engine.framework.GameRunner2;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Window;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import javax.swing.JOptionPane;

public class GameRunner {
    public static final int PORT = 3300;
    static /* synthetic */ Class class$games$strategy$engine$framework$GameRunner;

    public static Image getGameIcon(Window frame) {
        Image img = null;
        try {
            img = frame.getToolkit().getImage((class$games$strategy$engine$framework$GameRunner == null ? (class$games$strategy$engine$framework$GameRunner = GameRunner.class$("games.strategy.engine.framework.GameRunner")) : class$games$strategy$engine$framework$GameRunner).getResource("ta_icon.png"));
        }
        catch (Exception ex) {
            System.out.println("icon not loaded");
        }
        MediaTracker tracker = new MediaTracker(frame);
        tracker.addImage(img, 0);
        try {
            tracker.waitForAll();
        }
        catch (InterruptedException ex) {
            ex.printStackTrace();
        }
        return img;
    }

    public static boolean isWindows() {
        return System.getProperties().getProperty("os.name").toLowerCase().indexOf("windows") != -1;
    }

    public static boolean isMac() {
        return System.getProperties().getProperty("os.name").toLowerCase().indexOf("mac") != -1;
    }

    private static void checkJavaVersion() {
        boolean v14;
        String version = System.getProperties().getProperty("java.version");
        boolean v12 = version.indexOf("1.2") != -1;
        boolean v13 = version.indexOf("1.3") != -1;
        boolean bl = v14 = version.indexOf("1.4") != -1;
        if (v14 || v13 || v12) {
            if (!GameRunner.isMac()) {
                JOptionPane.showMessageDialog(null, "TripleA requires a java runtime greater than or equal to 5.0.\nPlease download a newer version of java from http://java.sun.com/", "ERROR", 0);
                System.exit(-1);
            } else if (GameRunner.isMac()) {
                JOptionPane.showMessageDialog(null, "TripleA requires a java runtime greater than or equal to 5.0 (Note, this requires Mac OS X >= 10.4)\nPlease download a newer version of java from http://www.apple.com/java/", "ERROR", 0);
                System.exit(-1);
            }
        }
    }

    public static void main(String[] args) {
        GameRunner.checkJavaVersion();
        GameRunner2.main(args);
    }

    public static File getUserRootFolder() {
        File userHome = new File(System.getProperties().getProperty("user.home"));
        File rootDir = GameRunner.isMac() ? new File(new File(userHome, "Documents"), "triplea") : new File(userHome, "triplea");
        return rootDir;
    }

    public static File getUserMapsFolder() {
        File f = new File(GameRunner.getUserRootFolder(), "maps");
        if (!f.exists()) {
            f.mkdirs();
        }
        return f;
    }

    public static boolean areWeOldExtraJar() {
        URL url = (class$games$strategy$engine$framework$GameRunner == null ? (class$games$strategy$engine$framework$GameRunner = GameRunner.class$("games.strategy.engine.framework.GameRunner")) : class$games$strategy$engine$framework$GameRunner).getResource("GameRunner.class");
        String fileName = url.getFile();
        try {
            fileName = URLDecoder.decode(fileName, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        String tripleaJarNameWithEngineVersion = GameRunner.getTripleaJarWithEngineVersionStringPath();
        if (fileName.indexOf(tripleaJarNameWithEngineVersion) != -1) {
            String path;
            String subString = fileName.substring("file:/".length() - (GameRunner.isWindows() ? 0 : 1), fileName.indexOf(tripleaJarNameWithEngineVersion) - 1);
            File f = new File(subString);
            if (!f.exists()) {
                throw new IllegalStateException("File not found:" + f);
            }
            try {
                path = f.getCanonicalPath();
            }
            catch (IOException e) {
                path = f.getPath();
            }
            return path.indexOf("old") != -1;
        }
        return false;
    }

    private static String getTripleaJarWithEngineVersionStringPath() {
        return "triplea_" + EngineVersion.VERSION.toStringFull("_") + ".jar!";
    }

    public static File getRootFolder() {
        URL url = (class$games$strategy$engine$framework$GameRunner == null ? (class$games$strategy$engine$framework$GameRunner = GameRunner.class$("games.strategy.engine.framework.GameRunner")) : class$games$strategy$engine$framework$GameRunner).getResource("GameRunner.class");
        int moveUpCount = (class$games$strategy$engine$framework$GameRunner == null ? (class$games$strategy$engine$framework$GameRunner = GameRunner.class$("games.strategy.engine.framework.GameRunner")) : class$games$strategy$engine$framework$GameRunner).getName().split("\\.").length + 1;
        String fileName = url.getFile();
        try {
            fileName = URLDecoder.decode(fileName, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        String tripleaJarName = "triplea.jar!";
        String tripleaJarNameWithEngineVersion = GameRunner.getTripleaJarWithEngineVersionStringPath();
        if (fileName.indexOf("triplea.jar!") != -1) {
            String subString = fileName.substring("file:/".length() - (GameRunner.isWindows() ? 0 : 1), fileName.indexOf("triplea.jar!") - 1);
            File f = new File(subString).getParentFile();
            if (!f.exists()) {
                throw new IllegalStateException("File not found:" + f);
            }
            return f;
        }
        if (fileName.indexOf(tripleaJarNameWithEngineVersion) != -1) {
            String subString = fileName.substring("file:/".length() - (GameRunner.isWindows() ? 0 : 1), fileName.indexOf(tripleaJarNameWithEngineVersion) - 1);
            File f = new File(subString).getParentFile();
            if (!f.exists()) {
                throw new IllegalStateException("File not found:" + f);
            }
            return f;
        }
        File f = new File(fileName);
        for (int i = 0; i < moveUpCount; ++i) {
            f = f.getParentFile();
        }
        if (!f.exists()) {
            System.err.println("Could not find root folder, does  not exist:" + f);
            return new File(System.getProperties().getProperty("user.dir"));
        }
        return f;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

