/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.engine.framework;

import games.strategy.engine.data.Change;
import games.strategy.engine.data.GameData;
import games.strategy.engine.data.PlayerID;
import games.strategy.engine.framework.GameDataUtils;
import games.strategy.engine.framework.IGame;
import games.strategy.engine.framework.IGameModifiedChannel;
import games.strategy.engine.history.EventChild;
import javax.swing.SwingUtilities;

public class HistorySynchronizer {
    private final GameData m_data;
    private int m_currentRound;
    private final IGame m_game;
    private final IGameModifiedChannel m_gameModifiedChannelListener = new IGameModifiedChannel(){

        public void gameDataChanged(final Change aChange) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    Change localizedChange = (Change)HistorySynchronizer.this.translateIntoMyData(aChange);
                    HistorySynchronizer.this.m_data.getHistory().getHistoryWriter().addChange(localizedChange);
                }
            });
        }

        public void startHistoryEvent(final String event) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    HistorySynchronizer.this.m_data.getHistory().getHistoryWriter().startEvent(event);
                }
            });
        }

        public void addChildToEvent(final String text, final Object renderingData) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    Object translatedRenderingData = HistorySynchronizer.this.translateIntoMyData(renderingData);
                    HistorySynchronizer.this.m_data.getHistory().getHistoryWriter().addChildToEvent(new EventChild(text, translatedRenderingData));
                }
            });
        }

        public void setRenderingData(final Object renderingData) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    Object translatedRenderingData = HistorySynchronizer.this.translateIntoMyData(renderingData);
                    HistorySynchronizer.this.m_data.getHistory().getHistoryWriter().setRenderingData(translatedRenderingData);
                }
            });
        }

        public void stepChanged(final String stepName, final String delegateName, final PlayerID player, final int round, final String displayName, boolean loadedFromSavedGame) {
            if (loadedFromSavedGame) {
                return;
            }
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    if (HistorySynchronizer.this.m_currentRound != round) {
                        HistorySynchronizer.this.m_currentRound = round;
                        HistorySynchronizer.this.m_data.getHistory().getHistoryWriter().startNextRound(HistorySynchronizer.this.m_currentRound);
                    }
                    HistorySynchronizer.this.m_data.getHistory().getHistoryWriter().startNextStep(stepName, delegateName, player, displayName);
                }
            });
        }

        public void shutDown() {
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HistorySynchronizer(GameData data, IGame game) {
        if (game.getData() == data) {
            throw new IllegalStateException("You dont need a history synchronizer to synchronize game data that is managed by an IGame");
        }
        this.m_data = data;
        this.m_data.forceChangesOnlyInSwingEventThread();
        data.acquireReadLock();
        try {
            this.m_currentRound = data.getSequence().getRound();
        }
        finally {
            data.releaseReadLock();
        }
        this.m_game = game;
        this.m_game.getChannelMessenger().registerChannelSubscriber(this.m_gameModifiedChannelListener, IGame.GAME_MODIFICATION_CHANNEL);
    }

    public void deactivate() {
        this.m_game.getChannelMessenger().unregisterChannelSubscriber(this.m_gameModifiedChannelListener, IGame.GAME_MODIFICATION_CHANNEL);
    }

    private Object translateIntoMyData(Object msg) {
        return GameDataUtils.translateIntoOtherGameData(msg, this.m_data);
    }
}

