/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.engine.framework;

import games.strategy.engine.framework.PlayerChoice;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.AbstractAction;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServerPlayerSelector
extends JFrame {
    private final Collection<PlayerChoice> m_playerChoices;
    private final Object m_lock = new Object();
    private Collection<String> m_remote;
    private final JTextField m_nameField;
    public AbstractAction m_done = new AbstractAction("done"){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent e) {
            if (!ServerPlayerSelector.this.isVisible()) {
                return;
            }
            ServerPlayerSelector.this.m_remote = new ArrayList();
            for (PlayerChoice choice : ServerPlayerSelector.this.m_playerChoices) {
                if (!choice.isRemote()) continue;
                ServerPlayerSelector.this.m_remote.add(choice.getPlayerName());
            }
            Object object = ServerPlayerSelector.this.m_lock;
            synchronized (object) {
                ServerPlayerSelector.this.m_lock.notifyAll();
            }
            ServerPlayerSelector.this.setVisible(false);
            ServerPlayerSelector.this.dispose();
        }
    };
    private final WindowListener m_doneOnClose = new WindowAdapter(){

        public void windowClosing(WindowEvent e) {
            ServerPlayerSelector.this.m_done.actionPerformed(null);
        }
    };

    public ServerPlayerSelector(String[] players) {
        super("Choose players");
        JPanel namePanel = new JPanel();
        namePanel.setLayout(new FlowLayout(0));
        namePanel.add(new JLabel("Name:"));
        this.m_nameField = new JTextField();
        this.m_nameField.setColumns(10);
        namePanel.add(this.m_nameField);
        this.getContentPane().add(namePanel);
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
        this.getContentPane().add(new JLabel("Choose player location."));
        this.m_playerChoices = new ArrayList<PlayerChoice>();
        for (int i = 0; i < players.length; ++i) {
            PlayerChoice current = new PlayerChoice(players[i]);
            this.m_playerChoices.add(current);
            this.getContentPane().add(current);
        }
        this.addWindowListener(this.m_doneOnClose);
        this.getContentPane().add(new JButton(this.m_done));
        this.pack();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<String> getRemotePlayers() {
        try {
            Object object = this.m_lock;
            synchronized (object) {
                this.setVisible(true);
                this.m_lock.wait();
            }
            if (this.m_remote == null) {
                return this.getRemotePlayers();
            }
            return this.m_remote;
        }
        catch (InterruptedException ie) {
            ie.printStackTrace();
            return this.getRemotePlayers();
        }
    }

    @Override
    public String getName() {
        return this.m_nameField.getText();
    }
}

