/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.engine.framework.mapDownload;

import games.strategy.engine.framework.GameRunner;
import games.strategy.engine.framework.mapDownload.DownloadFileDescription;
import games.strategy.engine.framework.mapDownload.DownloadFileProperties;
import games.strategy.engine.framework.mapDownload.DownloadRunnable;
import games.strategy.engine.framework.ui.background.BackgroundTaskRunner;
import games.strategy.ui.Util;
import games.strategy.util.EventThreadJOptionPane;
import games.strategy.util.Version;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.UUID;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InstallMapDialog
extends JDialog {
    private static final String DOWNLOAD_URL_PREFIX = "Location:";
    private JButton m_installButton;
    private JButton m_cancelButton;
    private final List<DownloadFileDescription> m_games;
    private JList m_gamesList;
    private JEditorPane m_descriptionPane;
    private JLabel m_urlLabel;

    private InstallMapDialog(Frame owner, List<DownloadFileDescription> games) {
        super(owner, "Select game to install", true);
        this.m_games = games;
        this.createComponents();
        this.layoutCoponents();
        this.setupListeners();
        this.setWidgetActivation();
    }

    private void createComponents() {
        this.m_installButton = new JButton("Install Game");
        this.m_cancelButton = new JButton("Cancel");
        Vector<String> gameNames = new Vector<String>();
        for (DownloadFileDescription d : this.m_games) {
            gameNames.add(d.getMapName());
        }
        this.m_gamesList = new JList(gameNames);
        this.m_gamesList.setSelectedIndex(0);
        this.m_gamesList.setSelectionMode(0);
        final ListCellRenderer oldRenderer = this.m_gamesList.getCellRenderer();
        this.m_gamesList.setCellRenderer(new ListCellRenderer(){

            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                if (value.toString().trim().length() == 0) {
                    value = " ";
                }
                return oldRenderer.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
            }
        });
        this.m_descriptionPane = new JEditorPane();
        this.m_descriptionPane.setEditable(false);
        this.m_descriptionPane.setContentType("text/html");
        this.m_descriptionPane.setBackground(new JLabel().getBackground());
        this.m_urlLabel = new JLabel(DOWNLOAD_URL_PREFIX);
    }

    private void layoutCoponents() {
        this.setLayout(new BorderLayout());
        JPanel buttonsPanel = new JPanel();
        this.add((Component)buttonsPanel, "South");
        buttonsPanel.setLayout(new BoxLayout(buttonsPanel, 0));
        buttonsPanel.add(Box.createGlue());
        buttonsPanel.add(this.m_cancelButton);
        buttonsPanel.add(this.m_installButton);
        buttonsPanel.add(Box.createGlue());
        buttonsPanel.setBorder(new EmptyBorder(20, 20, 20, 20));
        JScrollPane descriptionScroll = new JScrollPane();
        descriptionScroll.setViewportView(this.m_descriptionPane);
        descriptionScroll.setBorder(null);
        descriptionScroll.getViewport().setBorder(null);
        JScrollPane gamesScroll = new JScrollPane();
        gamesScroll.setViewportView(this.m_gamesList);
        gamesScroll.setBorder(null);
        gamesScroll.getViewport().setBorder(null);
        JPanel main = new JPanel();
        main.setBorder(new EmptyBorder(30, 30, 30, 30));
        main.setLayout(new BorderLayout());
        main.add((Component)gamesScroll, "West");
        main.add((Component)descriptionScroll, "Center");
        main.add((Component)this.m_urlLabel, "South");
        this.add((Component)main, "Center");
    }

    private void setupListeners() {
        this.m_cancelButton.addActionListener(new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                InstallMapDialog.this.setVisible(false);
            }
        });
        this.m_installButton.addActionListener(new AbstractAction(){

            public void actionPerformed(ActionEvent event) {
                InstallMapDialog.this.install(InstallMapDialog.this.getSelected());
            }
        });
        this.m_gamesList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                InstallMapDialog.this.setWidgetActivation();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void install(DownloadFileDescription selected) {
        File destination = new File(GameRunner.getUserMapsFolder(), selected.getMapName() + ".zip");
        if (destination.exists()) {
            String msg = "You have version " + InstallMapDialog.getVersionString(InstallMapDialog.getVersion(destination)) + " installed, replace with version " + InstallMapDialog.getVersionString(selected.getVersion()) + "?";
            int rVal = EventThreadJOptionPane.showConfirmDialog(this, msg, "Exit", 0);
            if (rVal != 0) {
                return;
            }
            if (!destination.delete()) {
                // empty if block
            }
        }
        File tempFile = new File(System.getProperty("java.io.tmpdir"), "tadownload:" + UUID.randomUUID().toString());
        tempFile.deleteOnExit();
        DownloadRunnable download = new DownloadRunnable(selected.getUrl());
        BackgroundTaskRunner.runInBackground(this.getRootPane(), "Downloading", download);
        if (download.getError() != null) {
            Util.notifyError(this, download.getError());
            return;
        }
        FileOutputStream sink = null;
        try {
            this.validateZip(download);
            sink = new FileOutputStream(tempFile);
            sink.write(download.getContents());
            sink.getFD().sync();
            DownloadFileProperties props = new DownloadFileProperties();
            props.setFrom(selected);
            DownloadFileProperties.saveForZip(destination, props);
        }
        catch (IOException e) {
            Util.notifyError(this, "Could not create write to temp file:" + e.getMessage());
            return;
        }
        finally {
            if (sink != null) {
                try {
                    sink.close();
                }
                catch (IOException e) {}
            }
        }
        try {
            ZipInputStream zis = new ZipInputStream(new FileInputStream(tempFile));
            try {
                while (zis.getNextEntry() != null) {
                    zis.read(new byte[128]);
                }
            }
            finally {
                zis.close();
            }
        }
        catch (IOException e) {
            Util.notifyError(this, "Invalid zip file:" + e.getMessage());
            return;
        }
        if (!tempFile.renameTo(destination)) {
            try {
                FileInputStream source = new FileInputStream(tempFile);
                try {
                    FileOutputStream destSink = new FileOutputStream(destination);
                    try {
                        InstallMapDialog.copy(destSink, source);
                        destSink.getFD().sync();
                    }
                    finally {
                        destSink.close();
                    }
                }
                finally {
                    source.close();
                    tempFile.delete();
                }
            }
            catch (IOException e) {
                Util.notifyError(this, e.getMessage());
                return;
            }
        }
        EventThreadJOptionPane.showMessageDialog(this.getRootPane(), (Object)"Map successfully installed, please restart TripleA before playing");
        this.setVisible(false);
    }

    private void validateZip(DownloadRunnable download) throws IOException {
        try {
            ZipEntry ze;
            ZipInputStream zis = new ZipInputStream(new ByteArrayInputStream(download.getContents()));
            while ((ze = zis.getNextEntry()) != null) {
                ze.getSize();
                zis.read(new byte[512]);
            }
        }
        catch (Exception e) {
            throw new IOException("zip file could not be opened, it may have been corrupted during the download, please try again");
        }
    }

    public static void copy(OutputStream sink, InputStream is) throws IOException {
        int read;
        byte[] b = new byte[8192];
        while ((read = is.read(b)) != -1) {
            sink.write(b, 0, read);
        }
    }

    private void setWidgetActivation() {
        if (this.m_gamesList.isSelectionEmpty()) {
            this.m_installButton.setEnabled(false);
            this.m_descriptionPane.setText("");
            this.m_urlLabel.setText(DOWNLOAD_URL_PREFIX);
        } else {
            DownloadFileDescription selected = this.getSelected();
            this.m_installButton.setEnabled(!selected.isDummyUrl());
            this.m_descriptionPane.setText(selected.getDescription());
            if (!selected.isDummyUrl()) {
                this.m_urlLabel.setText(DOWNLOAD_URL_PREFIX + selected.getUrl());
            }
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    InstallMapDialog.this.m_descriptionPane.scrollRectToVisible(new Rectangle(0, 0, 0, 0));
                }
            });
        }
    }

    private DownloadFileDescription getSelected() {
        DownloadFileDescription selected = null;
        for (DownloadFileDescription d : this.m_games) {
            if (!d.getMapName().equals(this.m_gamesList.getSelectedValue())) continue;
            selected = d;
        }
        return selected;
    }

    public static void installGames(Component parent, List<DownloadFileDescription> games) {
        Frame parentFrame = JOptionPane.getFrameForComponent(parent);
        InstallMapDialog dia = new InstallMapDialog(parentFrame, games);
        dia.setSize(800, 600);
        dia.setLocationRelativeTo(parentFrame);
        dia.setVisible(true);
    }

    private static String getVersionString(Version v) {
        if (v == null) {
            return "Unknown";
        }
        return v.toString();
    }

    private static Version getVersion(File zipFile) {
        DownloadFileProperties props = DownloadFileProperties.loadForZip(zipFile);
        return props.getVersion();
    }
}

