/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.engine.framework.networkMaintenance;

import games.strategy.net.INode;
import games.strategy.net.IServerMessenger;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.TreeSet;
import javax.swing.AbstractAction;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;

public class BanPlayerAction
extends AbstractAction {
    private final Component m_parent;
    private final IServerMessenger m_messenger;

    public BanPlayerAction(Component parent, IServerMessenger messenger) {
        super("Ban Player From Game...");
        this.m_parent = JOptionPane.getFrameForComponent(parent);
        this.m_messenger = messenger;
    }

    public void actionPerformed(ActionEvent e) {
        DefaultComboBoxModel<String> model = new DefaultComboBoxModel<String>();
        JComboBox combo = new JComboBox(model);
        model.addElement("");
        for (INode node : new TreeSet<INode>(this.m_messenger.getNodes())) {
            if (node.equals(this.m_messenger.getLocalNode())) continue;
            model.addElement(node.getName());
        }
        if (model.getSize() == 1) {
            JOptionPane.showMessageDialog(this.m_parent, "No remote players", "No Remote Players", 0);
            return;
        }
        int rVal = JOptionPane.showConfirmDialog(this.m_parent, combo, "Select player to ban", 2);
        if (rVal != 0) {
            return;
        }
        String name = (String)combo.getSelectedItem();
        for (INode node : this.m_messenger.getNodes()) {
            if (!node.getName().equals(name)) continue;
            String realName = node.getName().split(" ")[0];
            this.m_messenger.NotifyUsernameMiniBanningOfPlayer(realName);
            this.m_messenger.NotifyIPMiniBanningOfPlayer(node.getAddress().getHostAddress());
            this.m_messenger.NotifyMacMiniBanningOfPlayer(this.m_messenger.GetPlayerMac(node.getName()));
            this.m_messenger.removeConnection(node);
            return;
        }
    }
}

