/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.engine.framework.startup.launcher;

import games.strategy.engine.data.GameData;
import games.strategy.engine.data.PlayerID;
import games.strategy.engine.framework.GameDataManager;
import games.strategy.engine.framework.ServerGame;
import games.strategy.engine.framework.startup.launcher.AbstractLauncher;
import games.strategy.engine.framework.startup.launcher.ServerReady;
import games.strategy.engine.framework.startup.mc.ClientModel;
import games.strategy.engine.framework.startup.mc.GameSelectorModel;
import games.strategy.engine.framework.startup.mc.IClientChannel;
import games.strategy.engine.framework.startup.mc.IObserverWaitingToJoin;
import games.strategy.engine.framework.startup.mc.ServerModel;
import games.strategy.engine.framework.startup.ui.InGameLobbyWatcher;
import games.strategy.engine.framework.ui.SaveGameFileChooser;
import games.strategy.engine.gamePlayer.IGamePlayer;
import games.strategy.engine.lobby.server.GameDescription;
import games.strategy.engine.message.IChannelMessenger;
import games.strategy.engine.message.IRemoteMessenger;
import games.strategy.engine.message.MessengerException;
import games.strategy.engine.random.CryptoRandomSource;
import games.strategy.net.IMessenger;
import games.strategy.net.INode;
import games.strategy.net.Messengers;
import java.awt.Component;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.logging.Logger;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServerLauncher
extends AbstractLauncher {
    private static final Logger s_logger = Logger.getLogger(ServerLauncher.class.getName());
    public static final String SERVER_ROOT_DIR_PROPERTY = "triplea.server.root.dir";
    private final int m_clientCount;
    private final IRemoteMessenger m_remoteMessenger;
    private final IChannelMessenger m_channelMessenger;
    private final IMessenger m_messenger;
    private final Map<String, String> m_localPlayerMapping;
    private final Map<String, INode> m_remotelPlayers;
    private final ServerModel m_serverModel;
    private ServerGame m_serverGame;
    private Component m_ui;
    private final CountDownLatch m_erroLatch = new CountDownLatch(1);
    private volatile boolean m_isLaunching = true;
    private ServerReady m_serverReady;
    private volatile boolean m_abortLaunch = false;
    private final List<INode> m_observersThatTriedToJoinDuringStartup = Collections.synchronizedList(new ArrayList());
    private InGameLobbyWatcher m_inGameLobbyWatcher;

    public ServerLauncher(int clientCount, IRemoteMessenger remoteMessenger, IChannelMessenger channelMessenger, IMessenger messenger, GameSelectorModel gameSelectorModel, Map<String, String> localPlayerMapping, Map<String, INode> remotelPlayers, ServerModel serverModel) {
        super(gameSelectorModel);
        this.m_clientCount = clientCount;
        this.m_remoteMessenger = remoteMessenger;
        this.m_channelMessenger = channelMessenger;
        this.m_messenger = messenger;
        this.m_localPlayerMapping = localPlayerMapping;
        this.m_remotelPlayers = remotelPlayers;
        this.m_serverModel = serverModel;
    }

    public void setInGameLobbyWatcher(InGameLobbyWatcher watcher) {
        this.m_inGameLobbyWatcher = watcher;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void launchInNewThread(final Component parent) {
        try {
            boolean useSecureRandomSource;
            byte[] gameDataAsBytes;
            if (this.m_inGameLobbyWatcher != null) {
                this.m_inGameLobbyWatcher.setGameStatus(GameDescription.GameStatus.LAUNCHING, null);
            }
            this.m_ui = parent;
            this.m_serverModel.setServerLauncher(this);
            s_logger.fine("Starting server");
            this.m_serverReady = new ServerReady(this.m_clientCount);
            this.m_remoteMessenger.registerRemote(this.m_serverReady, ClientModel.CLIENT_READY_CHANNEL);
            try {
                gameDataAsBytes = ServerLauncher.gameDataToBytes(this.m_gameData);
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new IllegalStateException(e.getMessage());
            }
            Set<IGamePlayer> localPlayerSet = this.m_gameData.getGameLoader().createPlayers(this.m_localPlayerMapping);
            Messengers messengers = new Messengers(this.m_messenger, this.m_remoteMessenger, this.m_channelMessenger);
            this.m_serverGame = new ServerGame(this.m_gameData, localPlayerSet, this.m_remotelPlayers, messengers);
            this.m_serverGame.setInGameLobbyWatcher(this.m_inGameLobbyWatcher);
            ((IClientChannel)this.m_channelMessenger.getChannelBroadcastor(IClientChannel.CHANNEL_NAME)).doneSelectingPlayers(gameDataAsBytes, this.m_serverGame.getPlayerManager().getPlayerMapping());
            boolean bl = useSecureRandomSource = !this.m_remotelPlayers.isEmpty() && !this.m_localPlayerMapping.isEmpty();
            if (useSecureRandomSource) {
                PlayerID remotePlayer = this.m_serverGame.getPlayerManager().getRemoteOpponent(this.m_messenger.getLocalNode(), this.m_gameData);
                CryptoRandomSource randomSource = new CryptoRandomSource(remotePlayer, this.m_serverGame);
                this.m_serverGame.setRandomSource(randomSource);
            }
            try {
                this.m_gameData.getGameLoader().startGame(this.m_serverGame, localPlayerSet);
            }
            catch (IllegalStateException e) {
                this.m_abortLaunch = true;
                Throwable error = e;
                while (error.getMessage() == null) {
                    error = error.getCause();
                }
                final String message = error.getMessage();
                this.m_gameLoadingWindow.doneWait();
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        JOptionPane.showMessageDialog(null, message, "Warning", 2);
                    }
                });
            }
            catch (Exception e) {
                e.printStackTrace();
                this.m_abortLaunch = true;
            }
            this.m_serverReady.await();
            this.m_remoteMessenger.unregisterRemote(ClientModel.CLIENT_READY_CHANNEL);
            Thread t = new Thread("Triplea, start server game"){

                public void run() {
                    try {
                        ServerLauncher.this.m_isLaunching = false;
                        if (!ServerLauncher.this.m_abortLaunch) {
                            if (useSecureRandomSource) {
                                ServerLauncher.this.warmUpCryptoRandomSource();
                            }
                            ServerLauncher.this.m_gameLoadingWindow.doneWait();
                            ServerLauncher.this.m_serverGame.startGame();
                        } else {
                            ServerLauncher.this.m_serverGame.stopGame();
                            SwingUtilities.invokeLater(new Runnable(){

                                public void run() {
                                    JOptionPane.showMessageDialog(ServerLauncher.this.m_ui, "Error during startup, game aborted.");
                                }
                            });
                        }
                    }
                    catch (MessengerException me) {
                        me.printStackTrace(System.out);
                        try {
                            if (!ServerLauncher.this.m_abortLaunch) {
                                ServerLauncher.this.m_erroLatch.await();
                            }
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                    }
                    ServerLauncher.this.m_gameSelectorModel.loadDefaultGame(parent);
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            JOptionPane.getFrameForComponent(parent).setVisible(true);
                        }
                    });
                    ServerLauncher.this.m_serverModel.setServerLauncher(null);
                    ServerLauncher.this.m_serverModel.newGame();
                    if (ServerLauncher.this.m_inGameLobbyWatcher != null) {
                        ServerLauncher.this.m_inGameLobbyWatcher.setGameStatus(GameDescription.GameStatus.WAITING_FOR_PLAYERS, null);
                    }
                }
            };
            t.start();
        }
        finally {
            this.m_gameLoadingWindow.doneWait();
            if (this.m_inGameLobbyWatcher != null) {
                this.m_inGameLobbyWatcher.setGameStatus(GameDescription.GameStatus.IN_PROGRESS, this.m_serverGame);
            }
        }
    }

    private void warmUpCryptoRandomSource() {
        Thread t = new Thread("Warming up crypto random source"){

            public void run() {
                try {
                    ServerLauncher.this.m_serverGame.getRandomSource().getRandom(ServerLauncher.this.m_gameData.getDiceSides(), 2, "Warming up crpyto random source");
                }
                catch (RuntimeException re) {
                    re.printStackTrace(System.out);
                }
            }
        };
        t.start();
    }

    public void addObserver(IObserverWaitingToJoin observer, INode newNode) {
        if (this.m_isLaunching) {
            this.m_observersThatTriedToJoinDuringStartup.add(newNode);
            observer.cannotJoinGame("Game is launching, try again soon");
            return;
        }
        this.m_serverGame.addObserver(observer);
    }

    public static byte[] gameDataToBytes(GameData data) throws IOException {
        ByteArrayOutputStream sink = new ByteArrayOutputStream(25000);
        new GameDataManager().saveGame(sink, data);
        sink.flush();
        sink.close();
        return sink.toByteArray();
    }

    public void connectionLost(INode node) {
        if (this.m_isLaunching) {
            if (this.m_observersThatTriedToJoinDuringStartup.remove(node)) {
                return;
            }
            this.m_serverReady.clientReady();
            this.m_abortLaunch = true;
            return;
        }
        if (this.m_serverGame.getPlayerManager().isPlaying(node)) {
            if (this.m_serverGame.isGameSequenceRunning()) {
                this.saveAndEndGame(node);
            } else {
                this.m_serverGame.stopGame();
            }
            this.m_erroLatch.countDown();
        }
    }

    private void saveAndEndGame(final INode node) {
        SimpleDateFormat format = new SimpleDateFormat("MMM_dd_'at'_HH_mm");
        SaveGameFileChooser.ensureDefaultDirExists();
        final File f = new File(SaveGameFileChooser.DEFAULT_DIRECTORY, "connection_lost_on_" + format.format(new Date()) + ".tsvg");
        this.m_serverGame.saveGame(f);
        this.m_serverGame.stopGame();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                String message = "Connection lost to:" + node.getName() + " game is over.  Game saved to:" + f.getName();
                JOptionPane.showMessageDialog(JOptionPane.getFrameForComponent(ServerLauncher.this.m_ui), message);
            }
        });
    }
}

