/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.engine.framework.startup.ui;

import games.strategy.ui.IntTextField;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class ClientOptions
extends JDialog {
    private JTextField m_nameField;
    private JTextField m_addressField;
    private IntTextField m_portField;
    private boolean m_okPressed;
    private final Action m_okAction = new AbstractAction("Connect"){

        public void actionPerformed(ActionEvent e) {
            ClientOptions.this.setVisible(false);
            ClientOptions.this.m_okPressed = true;
        }
    };
    private final Action m_cancelAction = new AbstractAction("Cancel"){

        public void actionPerformed(ActionEvent e) {
            ClientOptions.this.setVisible(false);
        }
    };

    public ClientOptions(Component parent, String defaultName, int defaultPort, String defaultAddress) {
        super(JOptionPane.getFrameForComponent(parent), "Client options", true);
        this.initComponents();
        this.layoutComponents();
        this.m_nameField.setText(defaultName);
        this.m_portField.setValue(defaultPort);
        this.m_addressField.setText(defaultAddress);
        this.pack();
    }

    public String getName() {
        String s = this.m_nameField.getText().trim();
        if (s.length() > 20) {
            return s.substring(0, 20);
        }
        return s;
    }

    public String getAddress() {
        return this.m_addressField.getText().trim();
    }

    public int getPort() {
        return this.m_portField.getValue();
    }

    private void initComponents() {
        this.m_nameField = new JTextField(10);
        this.m_addressField = new JTextField(10);
        this.m_portField = new IntTextField(0, Integer.MAX_VALUE);
        this.m_portField.setColumns(7);
    }

    private void layoutComponents() {
        Container content = this.getContentPane();
        content.setLayout(new BorderLayout());
        JPanel title = new JPanel();
        title.add(new JLabel("Select client options"));
        content.add((Component)title, "North");
        Insets labelSpacing = new Insets(3, 7, 0, 0);
        Insets fieldSpacing = new Insets(3, 5, 0, 7);
        GridBagConstraints labelConstraints = new GridBagConstraints();
        labelConstraints.anchor = 13;
        labelConstraints.gridx = 0;
        labelConstraints.insets = labelSpacing;
        GridBagConstraints fieldConstraints = new GridBagConstraints();
        fieldConstraints.anchor = 17;
        fieldConstraints.gridx = 1;
        fieldConstraints.insets = fieldSpacing;
        JPanel fields = new JPanel();
        GridBagLayout layout = new GridBagLayout();
        fields.setLayout(layout);
        JLabel nameLabel = new JLabel("Name:");
        JLabel portLabel = new JLabel("Server Port:");
        JLabel addressLabel = new JLabel("Server Address:");
        layout.setConstraints(portLabel, labelConstraints);
        layout.setConstraints(nameLabel, labelConstraints);
        layout.setConstraints(addressLabel, labelConstraints);
        layout.setConstraints(this.m_portField, fieldConstraints);
        layout.setConstraints(this.m_nameField, fieldConstraints);
        layout.setConstraints(this.m_addressField, fieldConstraints);
        fields.add(nameLabel);
        fields.add(this.m_nameField);
        fields.add(portLabel);
        fields.add(this.m_portField);
        fields.add(addressLabel);
        fields.add(this.m_addressField);
        content.add((Component)fields, "Center");
        JPanel buttons = new JPanel();
        buttons.add(new JButton(this.m_okAction));
        buttons.add(new JButton(this.m_cancelAction));
        content.add((Component)buttons, "South");
    }

    public boolean getOKPressed() {
        return this.m_okPressed;
    }
}

