/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.engine.framework.startup.ui;

import games.strategy.engine.framework.GameRunner2;
import games.strategy.net.BareBonesBrowserLaunch;
import games.strategy.sound.SoundOptions;
import games.strategy.triplea.ui.TripleaMenu;
import games.strategy.util.EventThreadJOptionPane;
import games.strategy.util.Triple;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;

public class EnginePreferences
extends JDialog {
    private final Frame m_parentFrame;
    private JButton m_okButton;
    private JButton m_lookAndFeel;
    private JButton m_gameParser;
    private JButton m_donate;

    private EnginePreferences(Frame parentFrame) {
        super(parentFrame, "Edit TripleA Engine Preferences", true);
        this.m_parentFrame = parentFrame;
        this.createComponents();
        this.layoutCoponents();
        this.setupListeners();
        this.setWidgetActivation();
        this.addWindowListener(new WindowAdapter(){

            public void windowOpened(WindowEvent e) {
                EnginePreferences.this.m_okButton.requestFocus();
            }
        });
    }

    private void createComponents() {
        this.m_okButton = new JButton("OK");
        this.m_lookAndFeel = new JButton("Set Look And Feel...");
        this.m_gameParser = new JButton("Enable/Disable Delayed Parsing of Game XML's");
        this.m_donate = new JButton("Donate...");
    }

    private void layoutCoponents() {
        this.setLayout(new BorderLayout());
        JPanel buttonsPanel = new JPanel();
        this.add((Component)buttonsPanel, "Center");
        buttonsPanel.setLayout(new BoxLayout(buttonsPanel, 1));
        buttonsPanel.add(Box.createGlue());
        buttonsPanel.add(new JLabel("Change Engine Properties: "));
        buttonsPanel.add(new JLabel(" "));
        SoundOptions.addGlobalSoundSwitchCheckbox(buttonsPanel);
        buttonsPanel.add(new JLabel(" "));
        SoundOptions.addToPanel(buttonsPanel);
        buttonsPanel.add(new JLabel(" "));
        buttonsPanel.add(this.m_lookAndFeel);
        buttonsPanel.add(new JLabel(" "));
        buttonsPanel.add(this.m_gameParser);
        buttonsPanel.add(new JLabel(" "));
        buttonsPanel.add(this.m_donate);
        buttonsPanel.add(new JLabel(" "));
        buttonsPanel.add(Box.createGlue());
        buttonsPanel.setBorder(new EmptyBorder(20, 20, 20, 20));
        JPanel main = new JPanel();
        main.setBorder(new EmptyBorder(30, 30, 30, 30));
        main.setLayout(new BoxLayout(main, 0));
        main.add(this.m_okButton);
        this.add((Component)main, "South");
    }

    private void setupListeners() {
        this.m_okButton.addActionListener(new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                EnginePreferences.this.setVisible(false);
            }
        });
        this.m_lookAndFeel.addActionListener(new AbstractAction(){

            public void actionPerformed(ActionEvent event) {
                Triple<JList, Map<String, String>, String> lookAndFeel = TripleaMenu.getLookAndFeelList();
                JList list = (JList)lookAndFeel.getFirst();
                String currentKey = lookAndFeel.getThird();
                Map lookAndFeels = (Map)lookAndFeel.getSecond();
                if (JOptionPane.showConfirmDialog(EnginePreferences.this.m_parentFrame, list) == 0) {
                    String selectedValue = (String)list.getSelectedValue();
                    if (selectedValue == null) {
                        return;
                    }
                    if (selectedValue.equals(currentKey)) {
                        return;
                    }
                    GameRunner2.setDefaultLookAndFeel((String)lookAndFeels.get(selectedValue));
                    EventThreadJOptionPane.showMessageDialog(EnginePreferences.this.m_parentFrame, "The look and feel will update when you restart TripleA");
                }
            }
        });
        this.m_gameParser.addActionListener(new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                boolean delay;
                boolean current = GameRunner2.getDelayedParsing();
                Object[] options = new Object[]{"Parse Selected", "Parse All", "Cancel"};
                int answer = JOptionPane.showOptionDialog(EnginePreferences.this.m_parentFrame, new JLabel("<html>Delay Parsing of Game Data from XML until game is selected?<br><br>'" + options[1] + "' means each map is fully parsed as TripleA starts (useful for testing to make sure all your maps are valid)." + "<br><br>Your current setting is: '" + (current ? options[0].toString() : options[1].toString()) + "'</html>"), "Select Parsing Method", 1, 3, null, options, options[2]);
                if (answer == 2) {
                    return;
                }
                boolean bl = delay = answer == 0;
                if (delay == current) {
                    return;
                }
                GameRunner2.setDelayedParsing(delay);
                EventThreadJOptionPane.showMessageDialog(EnginePreferences.this.m_parentFrame, "Please restart TripleA to avoid any potential errors");
            }
        });
        this.m_donate.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                try {
                    BareBonesBrowserLaunch.openURL("https://sourceforge.net/donate/index.php?group_id=44492");
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
            }
        });
    }

    private void setWidgetActivation() {
    }

    public static void showEnginePreferences(JComponent parent) {
        Frame parentFrame = JOptionPane.getFrameForComponent(parent);
        EnginePreferences enginePrefs = new EnginePreferences(parentFrame);
        enginePrefs.pack();
        enginePrefs.setLocationRelativeTo(parentFrame);
        enginePrefs.setVisible(true);
    }

    public static void main(String[] args) {
        EnginePreferences.showEnginePreferences(null);
    }
}

