/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.engine.framework.startup.ui.editors;

import games.strategy.engine.framework.startup.ui.editors.IBean;
import games.strategy.engine.framework.startup.ui.editors.validators.IValidator;
import games.strategy.engine.framework.startup.ui.editors.validators.NonEmptyValidator;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.beans.PropertyChangeListener;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public abstract class EditorPanel
extends JPanel {
    public static final String EDITOR_CHANGE = "EditorChange";
    protected final Color m_labelColor = new JLabel().getForeground();

    public EditorPanel() {
        super(new GridBagLayout());
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        super.addPropertyChangeListener(EDITOR_CHANGE, listener);
    }

    protected boolean validateTextFieldNotEmpty(JTextField field, JLabel label) {
        return this.validateTextField(field, label, new NonEmptyValidator());
    }

    protected boolean validateTextField(JTextField field, JLabel label, IValidator IValidator2) {
        boolean valid = true;
        Color color = this.m_labelColor;
        if (!IValidator2.isValid(field.getText())) {
            valid = false;
            color = Color.RED;
            label.setForeground(color);
        }
        if (label != null) {
            label.setForeground(color);
        }
        return valid;
    }

    public abstract boolean isBeanValid();

    public abstract IBean getBean();

    public int getLabelWidth() {
        Component[] components;
        int width = 0;
        GridBagLayout layout = (GridBagLayout)this.getLayout();
        for (Component component : components = this.getComponents()) {
            if (!(component instanceof JLabel) || layout.getConstraints((Component)component).gridx != 0 || component.getPreferredSize().width <= width) continue;
            width = component.getPreferredSize().width;
        }
        return width;
    }

    public void setLabelWidth(int width) {
        Component[] components;
        GridBagLayout layout = (GridBagLayout)this.getLayout();
        for (Component component : components = this.getComponents()) {
            if (!(component instanceof JLabel) || layout.getConstraints((Component)component).gridx != 0) continue;
            int height = component.getPreferredSize().height;
            Dimension dimension = new Dimension(width, height);
            component.setPreferredSize(dimension);
            component.setSize(dimension);
        }
    }

    protected void fireEditorChanged() {
        this.firePropertyChange(EDITOR_CHANGE, null, null);
    }

    protected class EditorChangedFiringDocumentListener
    implements DocumentListener {
        protected EditorChangedFiringDocumentListener() {
        }

        public void changedUpdate(DocumentEvent e) {
            EditorPanel.this.fireEditorChanged();
        }

        public void insertUpdate(DocumentEvent e) {
            EditorPanel.this.fireEditorChanged();
        }

        public void removeUpdate(DocumentEvent e) {
            EditorPanel.this.fireEditorChanged();
        }
    }
}

