/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.engine.framework.startup.ui.editors;

import games.strategy.engine.framework.startup.ui.MainFrame;
import games.strategy.engine.framework.startup.ui.editors.EditorPanel;
import games.strategy.engine.framework.startup.ui.editors.IBean;
import games.strategy.engine.pbem.IForumPoster;
import games.strategy.engine.pbem.NullForumPoster;
import games.strategy.ui.ProgressWindow;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.imageio.ImageIO;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

public class ForumPosterEditor
extends EditorPanel {
    private final JButton m_viewPosts = new JButton("View Forum");
    private final JButton m_testForum = new JButton("Test Post");
    private final JLabel m_loginLabel = new JLabel("Login:");
    private final JLabel m_passwordLabel = new JLabel("Password:");
    private final JTextField m_login = new JTextField();
    private final JTextField m_password = new JPasswordField();
    private final JTextField m_topicIdField = new JTextField();
    private final JLabel m_topicIdLabel = new JLabel("Topic Id:");
    private final JCheckBox m_includeSaveGame = new JCheckBox("Attach save game to summary");
    private final IForumPoster m_bean;

    public ForumPosterEditor(IForumPoster bean) {
        this.m_bean = bean;
        boolean bottomSpace = true;
        int labelSpace = 2;
        int row = 0;
        if (this.m_bean.getCanViewPosted()) {
            this.add((Component)this.m_topicIdLabel, new GridBagConstraints(0, row, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 1, 2), 0, 0));
            this.add((Component)this.m_topicIdField, new GridBagConstraints(1, row, 1, 1, 1.0, 0.0, 13, 2, new Insets(0, 0, 1, 0), 0, 0));
            this.m_topicIdField.setText(this.m_bean.getTopicId());
            this.add((Component)this.m_viewPosts, new GridBagConstraints(2, row, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 2, 1, 0), 0, 0));
            ++row;
        }
        this.add((Component)this.m_loginLabel, new GridBagConstraints(0, row, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 1, 2), 0, 0));
        this.add((Component)this.m_login, new GridBagConstraints(1, row, 2, 1, 1.0, 0.0, 13, 2, new Insets(0, 0, 1, 0), 0, 0));
        this.m_login.setText(this.m_bean.getUsername());
        this.add((Component)this.m_passwordLabel, new GridBagConstraints(0, ++row, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 1, 2), 0, 0));
        this.add((Component)this.m_password, new GridBagConstraints(1, row, 2, 1, 1.0, 0.0, 13, 2, new Insets(0, 0, 1, 0), 0, 0));
        this.m_password.setText(this.m_bean.getPassword());
        ++row;
        if (this.m_bean.supportsSaveGame()) {
            this.add((Component)this.m_includeSaveGame, new GridBagConstraints(0, row, 2, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.m_includeSaveGame.setSelected(this.m_bean.getIncludeSaveGame());
            this.add((Component)this.m_testForum, new GridBagConstraints(2, row, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
        } else {
            this.add((Component)this.m_testForum, new GridBagConstraints(3, row, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
        }
        this.setupListeners();
    }

    private void setupListeners() {
        this.m_viewPosts.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ((IForumPoster)ForumPosterEditor.this.getBean()).viewPosted();
            }
        });
        this.m_testForum.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ForumPosterEditor.this.testForum();
            }
        });
        EditorPanel.EditorChangedFiringDocumentListener docListener = new EditorPanel.EditorChangedFiringDocumentListener();
        this.m_login.getDocument().addDocumentListener(docListener);
        this.m_password.getDocument().addDocumentListener(docListener);
        this.m_topicIdField.getDocument().addDocumentListener(docListener);
    }

    void testForum() {
        final IForumPoster poster = (IForumPoster)this.getBean();
        final ProgressWindow progressWindow = new ProgressWindow(MainFrame.getInstance(), poster.getTestMessage());
        progressWindow.setVisible(true);
        Runnable runnable = new Runnable(){

            public void run() {
                if (poster.getIncludeSaveGame()) {
                    try {
                        File f = File.createTempFile("123", "test");
                        f.deleteOnExit();
                        BufferedImage image = new BufferedImage(130, 40, 1);
                        Graphics g = image.getGraphics();
                        g.drawString("Testing file upload", 10, 20);
                        try {
                            ImageIO.write((RenderedImage)image, "jpg", f);
                        }
                        catch (IOException e) {
                            // empty catch block
                        }
                        poster.addSaveGame(f, "Test.jpg");
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                poster.postTurnSummary("Test summary from TripleA " + new SimpleDateFormat("HH:mm:ss").format(new Date()), "Testing Forum poster");
                progressWindow.setVisible(false);
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        try {
                            JOptionPane.showMessageDialog(MainFrame.getInstance(), ForumPosterEditor.this.m_bean.getTurnSummaryRef(), "Test Turn Summary Post", 1);
                        }
                        catch (HeadlessException headlessException) {
                            // empty catch block
                        }
                    }
                });
            }
        };
        Thread t = new Thread(runnable);
        t.start();
    }

    public boolean isBeanValid() {
        if (this.m_bean instanceof NullForumPoster) {
            return true;
        }
        boolean loginValid = this.validateTextFieldNotEmpty(this.m_login, this.m_loginLabel);
        boolean passwordValid = this.validateTextFieldNotEmpty(this.m_password, this.m_passwordLabel);
        boolean idValid = true;
        if (this.m_bean.getCanViewPosted()) {
            idValid = this.validateTextFieldNotEmpty(this.m_topicIdField, this.m_topicIdLabel);
            this.m_viewPosts.setEnabled(idValid);
        } else {
            this.m_topicIdLabel.setForeground(this.m_labelColor);
            this.m_viewPosts.setEnabled(false);
        }
        boolean allValid = loginValid && passwordValid && idValid;
        this.m_testForum.setEnabled(allValid);
        return allValid;
    }

    public IBean getBean() {
        this.m_bean.setTopicId(this.m_topicIdField.getText());
        this.m_bean.setUsername(this.m_login.getText());
        this.m_bean.setPassword(this.m_password.getText());
        this.m_bean.setIncludeSaveGame(this.m_includeSaveGame.isSelected());
        return this.m_bean;
    }
}

