/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.engine.framework.startup.ui.editors;

import games.strategy.engine.framework.startup.ui.editors.DisplayNameComboBoxRender;
import games.strategy.engine.framework.startup.ui.editors.EditorPanel;
import games.strategy.engine.framework.startup.ui.editors.IBean;
import games.strategy.triplea.help.HelpSupport;
import games.strategy.triplea.ui.JButtonDialog;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelectAndViewEditor
extends EditorPanel {
    JComboBox m_selector = new JComboBox();
    JPanel m_view = new JPanel();
    JButton m_helpButton = new JButton("Help?");
    private final PropertyChangeListener m_properChangeListener;
    private EditorPanel m_editor;
    private final JLabel m_selectorLabel;
    private final JEditorPane m_helpPanel;
    private final String m_defaultHelp;

    public SelectAndViewEditor(String labelTitle, String defaultHelp) {
        this.m_defaultHelp = defaultHelp;
        Font oldFont = this.m_helpButton.getFont();
        this.m_helpButton.setFont(new Font(oldFont.getName(), 1, oldFont.getSize()));
        this.m_view.setLayout(new GridBagLayout());
        this.m_selectorLabel = new JLabel(labelTitle + ":");
        this.add((Component)this.m_selectorLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 1, 2), 0, 0));
        this.add((Component)this.m_selector, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 18, 2, new Insets(0, 0, 1, 0), 0, 0));
        this.add((Component)this.m_helpButton, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 12, 0, new Insets(0, 0, 1, 0), 0, 0));
        this.add((Component)this.m_view, new GridBagConstraints(0, 1, 3, 1, 1.0, 1.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.m_selector.setRenderer(new DisplayNameComboBoxRender());
        this.m_selector.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    SelectAndViewEditor.this.updateView();
                    SelectAndViewEditor.this.fireEditorChanged();
                }
            }
        });
        this.m_properChangeListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                SelectAndViewEditor.this.fireEditorChanged();
            }
        };
        this.m_helpPanel = new JEditorPane();
        this.m_helpPanel.setEditable(false);
        this.m_helpPanel.setContentType("text/html");
        this.m_helpPanel.setAutoscrolls(true);
        this.m_helpPanel.setBackground(this.m_selectorLabel.getBackground());
        Dimension preferredSize = new Dimension(500, 500);
        this.m_helpPanel.setPreferredSize(preferredSize);
        this.m_helpPanel.setSize(preferredSize);
        final JScrollPane notesScroll = new JScrollPane();
        notesScroll.setViewportView(this.m_helpPanel);
        notesScroll.setBorder(null);
        notesScroll.getViewport().setBorder(null);
        this.m_helpButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                String helpText = SelectAndViewEditor.this.getBean() == null ? HelpSupport.loadHelp(SelectAndViewEditor.this.m_defaultHelp) : SelectAndViewEditor.this.getBean().getHelpText();
                SelectAndViewEditor.this.m_helpPanel.setText(helpText);
                JButtonDialog.showDialog(SelectAndViewEditor.this, "Help", (Object)notesScroll, "Close");
            }
        });
    }

    private void updateView() {
        if (this.m_editor != null) {
            this.m_editor.removePropertyChangeListener(this.m_properChangeListener);
        }
        this.m_view.removeAll();
        IBean item = (IBean)this.m_selector.getSelectedItem();
        this.m_editor = item.getEditor();
        if (this.m_editor != null) {
            this.m_editor.addPropertyChangeListener(this.m_properChangeListener);
            this.m_view.add((Component)this.m_editor, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.m_editor.isBeanValid();
        }
        this.revalidate();
        this.alignLabels();
    }

    private void alignLabels() {
        int height = this.m_selectorLabel.getPreferredSize().height;
        int width = this.m_selectorLabel.getPreferredSize().width;
        if (this.m_editor != null) {
            int labelWidth = this.m_editor.getLabelWidth();
            if (width < labelWidth) {
                width = labelWidth;
            } else {
                this.m_editor.setLabelWidth(width);
            }
        }
        Dimension dimension = new Dimension(width, height);
        this.m_selectorLabel.setPreferredSize(dimension);
        this.m_selectorLabel.setSize(dimension);
    }

    public void setBeans(List<? extends IBean> beans) {
        this.m_selector.setModel(new DefaultComboBoxModel<Object>(beans.toArray()));
        this.updateView();
    }

    @Override
    public boolean isBeanValid() {
        return this.m_editor == null || this.m_editor.isBeanValid();
    }

    @Override
    public IBean getBean() {
        if (this.m_editor == null) {
            return null;
        }
        return this.m_editor.getBean();
    }

    public void setSelectedBean(IBean bean) {
        DefaultComboBoxModel model = (DefaultComboBoxModel)this.m_selector.getModel();
        DefaultComboBoxModel<IBean> newModel = new DefaultComboBoxModel<IBean>();
        boolean found = false;
        for (int i = 0; i < model.getSize(); ++i) {
            IBean candidate = (IBean)model.getElementAt(i);
            if (candidate.sameType(bean)) {
                found = true;
                newModel.addElement(bean);
                continue;
            }
            newModel.addElement(candidate);
        }
        if (found) {
            this.m_selector.setModel(newModel);
        } else {
            model.addElement(bean);
        }
        this.m_selector.setSelectedItem(bean);
        this.updateView();
    }
}

