/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.engine.framework.ui;

import games.strategy.engine.framework.GameRunner;
import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;

public class SaveGameFileChooser
extends JFileChooser {
    public static final String AUTOSAVE_FILE_NAME = "autosave.tsvg";
    public static final String AUTOSAVE_ODD_ROUND_FILE_NAME = "autosave_round_odd.tsvg";
    public static final String AUTOSAVE_EVEN_ROUND_FILE_NAME = "autosave_round_even.tsvg";
    public static final File DEFAULT_DIRECTORY = new File(GameRunner.getUserRootFolder(), "savedGames");
    private static SaveGameFileChooser s_instance;
    FileFilter m_gameDataFileFilter = new FileFilter(){

        public boolean accept(File f) {
            if (f.isDirectory()) {
                return true;
            }
            return f.getName().endsWith(".tsvg") || f.getName().endsWith(".svg") || f.getName().endsWith("tsvg.gz");
        }

        public String getDescription() {
            return "Saved Games, *.tsvg";
        }
    };

    public static SaveGameFileChooser getInstance() {
        if (s_instance == null) {
            s_instance = new SaveGameFileChooser();
        }
        return s_instance;
    }

    public SaveGameFileChooser() {
        this.setFileFilter(this.m_gameDataFileFilter);
        SaveGameFileChooser.ensureDefaultDirExists();
        this.setCurrentDirectory(DEFAULT_DIRECTORY);
    }

    public static void ensureDefaultDirExists() {
        SaveGameFileChooser.ensureDirectoryExists(DEFAULT_DIRECTORY);
    }

    private static void ensureDirectoryExists(File f) {
        if (!f.getParentFile().exists()) {
            SaveGameFileChooser.ensureDirectoryExists(f.getParentFile());
        }
        if (!f.exists()) {
            f.mkdir();
        }
    }
}

