/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.engine.lobby.client.login;

import games.strategy.engine.framework.GameRunner2;
import games.strategy.engine.lobby.server.userDB.DBUser;
import games.strategy.engine.lobby.server.userDB.DBUserController;
import games.strategy.ui.Util;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;

public class CreateUpdateAccountPanel
extends JPanel {
    private JDialog m_dialog;
    private JTextField m_userName;
    private JTextField m_email;
    private JPasswordField m_password;
    private JPasswordField m_password2;
    private JButton m_okButton;
    private JButton m_cancelButton;
    private ReturnValue m_returnValue;

    public static CreateUpdateAccountPanel newUpdatePanel(DBUser user) {
        CreateUpdateAccountPanel panel = new CreateUpdateAccountPanel(false);
        panel.m_userName.setText(user.getName());
        panel.m_userName.setEditable(false);
        panel.m_email.setText(user.getEmail());
        return panel;
    }

    public static CreateUpdateAccountPanel newCreatePanel() {
        CreateUpdateAccountPanel panel = new CreateUpdateAccountPanel(true);
        return panel;
    }

    private CreateUpdateAccountPanel(boolean create) {
        this.createComponents();
        this.layoutComponents(create);
        this.setupListeners();
        this.setWidgetActivation();
    }

    private void createComponents() {
        this.m_userName = new JTextField();
        this.m_email = new JTextField();
        this.m_password = new JPasswordField();
        this.m_password2 = new JPasswordField();
        this.m_cancelButton = new JButton("Cancel");
        this.m_okButton = new JButton("OK");
    }

    private void layoutComponents(boolean create) {
        JLabel label = new JLabel(new ImageIcon(Util.getBanner(create ? "Create Account" : "Update Account")));
        this.setLayout(new BorderLayout());
        this.add((Component)label, "North");
        JPanel main = new JPanel();
        this.add((Component)main, "Center");
        main.setLayout(new GridBagLayout());
        main.add((Component)new JLabel("Username:"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(10, 20, 0, 0), 0, 0));
        main.add((Component)this.m_userName, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 13, 1, new Insets(10, 5, 0, 40), 0, 0));
        main.add((Component)new JLabel("Password:"), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 20, 0, 0), 0, 0));
        main.add((Component)this.m_password, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 13, 1, new Insets(5, 5, 0, 40), 0, 0));
        main.add((Component)new JLabel("Re-type Password:"), new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 20, 0, 0), 0, 0));
        main.add((Component)this.m_password2, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 13, 1, new Insets(5, 5, 0, 40), 0, 0));
        main.add((Component)new JLabel("Email:"), new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 20, 15, 0), 0, 0));
        main.add((Component)this.m_email, new GridBagConstraints(1, 3, 1, 1, 1.0, 1.0, 13, 1, new Insets(5, 5, 15, 40), 0, 0));
        JPanel buttons = new JPanel();
        buttons.setLayout(new FlowLayout(2));
        buttons.add(this.m_okButton);
        buttons.add(this.m_cancelButton);
        this.add((Component)buttons, "South");
    }

    public static void main(String[] args) {
        GameRunner2.setupLookAndFeel();
        JDialog d = new JDialog();
        d.add(new CreateUpdateAccountPanel(false));
        d.setDefaultCloseOperation(3);
        d.pack();
        d.setVisible(true);
    }

    private void setupListeners() {
        this.m_cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CreateUpdateAccountPanel.this.m_dialog.setVisible(false);
            }
        });
        this.m_okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CreateUpdateAccountPanel.this.okPressed();
            }
        });
    }

    private void okPressed() {
        if (!this.m_password.getText().equals(this.m_password2.getText())) {
            JOptionPane.showMessageDialog(this, "The passwords do not match", "Passwords Do Not Match", 0);
            this.m_password.setText("");
            this.m_password2.setText("");
            return;
        }
        if (!games.strategy.util.Util.isMailValid(this.m_email.getText())) {
            JOptionPane.showMessageDialog(this, "You must enter a valid email", "No email", 0);
            return;
        }
        if (DBUserController.validateUserName(this.m_userName.getText()) != null) {
            JOptionPane.showMessageDialog(this, DBUserController.validateUserName(this.m_userName.getText()), "Invalid Username", 0);
            return;
        }
        if (this.m_password.getPassword().length == 0) {
            JOptionPane.showMessageDialog(this, "You must enter a password", "No Password", 0);
            return;
        }
        if (this.m_password.getPassword().length < 3) {
            JOptionPane.showMessageDialog(this, "Passwords must be at least three characters long", "Invalid password", 0);
            return;
        }
        this.m_returnValue = ReturnValue.OK;
        this.m_dialog.setVisible(false);
    }

    private void setWidgetActivation() {
    }

    public ReturnValue show(Window parent) {
        this.m_dialog = new JDialog(JOptionPane.getFrameForComponent(parent), "Login", true);
        this.m_dialog.getContentPane().add(this);
        this.m_dialog.pack();
        this.m_dialog.setLocationRelativeTo(parent);
        this.m_dialog.setVisible(true);
        this.m_dialog.dispose();
        this.m_dialog = null;
        if (this.m_returnValue == null) {
            return ReturnValue.CANCEL;
        }
        return this.m_returnValue;
    }

    public String getPassword() {
        return this.m_password.getText();
    }

    public String getEmail() {
        return this.m_email.getText();
    }

    public String getUserName() {
        return this.m_userName.getText();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ReturnValue {
        CANCEL,
        OK;

    }
}

