/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.engine.lobby.client.login;

import games.strategy.engine.framework.GameRunner2;
import games.strategy.engine.lobby.server.userDB.DBUserController;
import games.strategy.ui.Util;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.logging.Logger;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;

public class LoginPanel
extends JPanel {
    private static final Logger s_logger = Logger.getLogger(LoginPanel.class.getName());
    public static final String LAST_LOGIN_NAME_PREF = "LAST_LOGIN_NAME_PREF";
    public static final String ANONYMOUS_LOGIN_PREF = "ANONYMOUS_LOGIN_PREF";
    private JDialog m_dialog;
    private JPasswordField m_password;
    private JTextField m_userName;
    private JCheckBox m_anonymous;
    private JButton m_createAccount;
    private ReturnValue m_returnValue;
    private JButton m_logon;
    private JButton m_cancel;

    public LoginPanel() {
        this.createComponents();
        this.layoutComponents();
        this.setupListeners();
        this.readDefaults();
        this.setWidgetActivation();
    }

    private void readDefaults() {
        Preferences prefs = Preferences.userNodeForPackage(this.getClass());
        String name = prefs.get(LAST_LOGIN_NAME_PREF, System.getProperty("user.name"));
        boolean anonymous = prefs.getBoolean(ANONYMOUS_LOGIN_PREF, true);
        this.m_anonymous.setSelected(anonymous);
        this.m_userName.setText(name);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (!LoginPanel.this.m_anonymous.isSelected()) {
                    LoginPanel.this.m_password.requestFocusInWindow();
                } else {
                    LoginPanel.this.m_userName.requestFocusInWindow();
                }
            }
        });
    }

    private void createComponents() {
        this.m_password = new JPasswordField();
        this.m_userName = new JTextField();
        this.m_anonymous = new JCheckBox("Login Anonymously?");
        this.m_createAccount = new JButton("Create Account...");
        this.m_logon = new JButton("Login");
        this.m_cancel = new JButton("Cancel");
    }

    private void layoutComponents() {
        JLabel label = new JLabel(new ImageIcon(Util.getBanner("Login")));
        this.setLayout(new BorderLayout());
        this.add((Component)label, "North");
        JPanel main = new JPanel();
        this.add((Component)main, "Center");
        main.setLayout(new GridBagLayout());
        main.add((Component)new JLabel("Username:"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(10, 20, 0, 0), 0, 0));
        main.add((Component)this.m_userName, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 13, 1, new Insets(10, 5, 0, 40), 0, 0));
        main.add((Component)new JLabel("Password:"), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 20, 0, 0), 0, 0));
        main.add((Component)this.m_password, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 13, 1, new Insets(5, 5, 0, 40), 0, 0));
        main.add((Component)this.m_anonymous, new GridBagConstraints(0, 2, 2, 1, 1.0, 1.0, 17, 0, new Insets(5, 20, 0, 0), 0, 0));
        main.add((Component)this.m_createAccount, new GridBagConstraints(0, 3, 2, 1, 0.0, 0.0, 17, 0, new Insets(5, 20, 0, 0), 0, 0));
        JPanel buttons = new JPanel();
        buttons.setLayout(new FlowLayout(2));
        buttons.add(this.m_logon);
        buttons.add(this.m_cancel);
        this.add((Component)buttons, "South");
    }

    private void setupListeners() {
        this.m_logon.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                LoginPanel.this.logonPressed();
            }
        });
        this.m_createAccount.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                LoginPanel.this.m_returnValue = ReturnValue.CREATE_ACCOUNT;
                LoginPanel.this.m_dialog.setVisible(false);
            }
        });
        this.m_cancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                LoginPanel.this.m_dialog.setVisible(false);
            }
        });
        this.m_anonymous.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                LoginPanel.this.setWidgetActivation();
            }
        });
        AbstractAction enterAction = new AbstractAction(){

            public void actionPerformed(ActionEvent arg0) {
                LoginPanel.this.logonPressed();
            }
        };
        String key = "logon.through.enter.key";
        this.getActionMap().put("logon.through.enter.key", enterAction);
        this.getActionMap().put("logon.through.enter.key", enterAction);
        this.getInputMap(2).put(KeyStroke.getKeyStroke(10, 0), "logon.through.enter.key");
    }

    private void logonPressed() {
        String userName = this.m_userName.getText();
        boolean anonymous = this.m_anonymous.isSelected();
        if (DBUserController.validateUserName(userName) != null) {
            JOptionPane.showMessageDialog(this, DBUserController.validateUserName(userName), "Invalid Username", 0);
            return;
        }
        if (this.m_password.getPassword().length == 0 && !anonymous) {
            JOptionPane.showMessageDialog(this, "You must enter a password", "No Password", 0);
            return;
        }
        if (this.m_password.getPassword().length < 3 && !anonymous) {
            JOptionPane.showMessageDialog(this, "Passwords must be at least three characters long", "Invalid password", 0);
            return;
        }
        this.m_returnValue = ReturnValue.LOGON;
        this.m_dialog.setVisible(false);
    }

    public static void storePrefs(String userName, boolean anonymous) {
        Preferences prefs = Preferences.userNodeForPackage(LoginPanel.class);
        prefs.put(LAST_LOGIN_NAME_PREF, userName);
        prefs.putBoolean(ANONYMOUS_LOGIN_PREF, anonymous);
        try {
            prefs.flush();
        }
        catch (BackingStoreException e) {
            s_logger.warning(e.getMessage());
        }
    }

    private void setWidgetActivation() {
        if (!this.m_anonymous.isSelected()) {
            this.m_password.setEnabled(true);
            this.m_password.setBackground(this.m_userName.getBackground());
        } else {
            this.m_password.setEnabled(false);
            this.m_password.setBackground(this.getBackground());
        }
    }

    public static void main(String[] args) {
        GameRunner2.setupLookAndFeel();
        JDialog d = new JDialog();
        d.add(new LoginPanel());
        d.setDefaultCloseOperation(3);
        d.pack();
        d.setVisible(true);
    }

    public boolean isAnonymous() {
        return this.m_anonymous.isSelected();
    }

    public String getUserName() {
        return this.m_userName.getText();
    }

    public String getPassword() {
        return this.m_password.getText();
    }

    public ReturnValue show(Window parent) {
        this.m_dialog = new JDialog(JOptionPane.getFrameForComponent(parent), "Login", true);
        this.m_dialog.getContentPane().add(this);
        this.m_dialog.pack();
        this.m_dialog.setLocationRelativeTo(parent);
        this.m_dialog.setVisible(true);
        this.m_dialog.dispose();
        this.m_dialog = null;
        if (this.m_returnValue == null) {
            return ReturnValue.CANCEL;
        }
        return this.m_returnValue;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ReturnValue {
        CANCEL,
        LOGON,
        CREATE_ACCOUNT;

    }
}

