/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.engine.lobby.server;

import games.strategy.engine.chat.ChatController;
import games.strategy.engine.chat.StatusManager;
import games.strategy.engine.lobby.server.ILobbyGameBroadcaster;
import games.strategy.engine.lobby.server.LobbyGameController;
import games.strategy.engine.lobby.server.ModeratorController;
import games.strategy.engine.lobby.server.UserManager;
import games.strategy.engine.lobby.server.headless.HeadlessLobbyConsole;
import games.strategy.engine.lobby.server.login.LobbyLoginValidator;
import games.strategy.engine.lobby.server.ui.LobbyAdminConsole;
import games.strategy.engine.lobby.server.userDB.Database;
import games.strategy.net.IServerMessenger;
import games.strategy.net.Messengers;
import games.strategy.net.ServerMessenger;
import games.strategy.triplea.util.LoggingPrintStream;
import games.strategy.util.Version;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;

public class LobbyServer {
    private static final String PORT = "triplea.lobby.port";
    private static final String UI = "triplea.lobby.ui";
    private static final String CONSOLE = "triplea.lobby.console";
    public static final String ADMIN_USERNAME = "Admin";
    private static final Logger s_logger = Logger.getLogger(LobbyServer.class.getName());
    public static final String LOBBY_CHAT = "_LOBBY_CHAT";
    public static final Version LOBBY_VERSION = new Version(1, 0, 0);
    private final Messengers m_messengers;

    public LobbyServer(int port) {
        ServerMessenger server;
        try {
            server = new ServerMessenger(ADMIN_USERNAME, port);
        }
        catch (IOException ex) {
            s_logger.log(Level.SEVERE, ex.toString());
            throw new IllegalStateException(ex.getMessage());
        }
        this.m_messengers = new Messengers(server);
        server.setLoginValidator(new LobbyLoginValidator());
        new UserManager().register(this.m_messengers.getRemoteMessenger());
        ModeratorController moderatorController = new ModeratorController(server);
        moderatorController.register(this.m_messengers.getRemoteMessenger());
        new ChatController(LOBBY_CHAT, this.m_messengers, moderatorController);
        StatusManager statusManager = new StatusManager(this.m_messengers);
        statusManager.shutDown();
        LobbyGameController controller = new LobbyGameController((ILobbyGameBroadcaster)this.m_messengers.getChannelMessenger().getChannelBroadcastor(ILobbyGameBroadcaster.GAME_BROADCASTER_CHANNEL), server);
        controller.register(this.m_messengers.getRemoteMessenger());
        server.setAcceptNewConnections(true);
    }

    private static void setUpLogging() {
        try {
            LogManager.getLogManager().readConfiguration(ClassLoader.getSystemResourceAsStream("server-logging.properties"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Logger.getAnonymousLogger().info("Redirecting std out");
        System.setErr(new LoggingPrintStream("ERROR", Level.SEVERE));
        System.setOut(new LoggingPrintStream("OUT", Level.INFO));
    }

    public static void main(String[] args) {
        try {
            InputStream in = System.in;
            PrintStream out = System.out;
            LobbyServer.setUpLogging();
            int port = Integer.parseInt(System.getProperty(PORT, "3303"));
            System.out.println("Trying to listen on port:" + port);
            LobbyServer server = new LobbyServer(port);
            System.out.println("Starting database");
            Database.getConnection().close();
            s_logger.info("Lobby started");
            if (Boolean.parseBoolean(System.getProperty(UI, "false"))) {
                LobbyServer.startUI(server);
            }
            if (Boolean.parseBoolean(System.getProperty(CONSOLE, "false"))) {
                LobbyServer.startConsole(server, in, out);
            }
        }
        catch (Exception ex) {
            s_logger.log(Level.SEVERE, ex.toString(), ex);
        }
    }

    private static void startConsole(LobbyServer server, InputStream in, PrintStream out) {
        System.out.println("starting console");
        new HeadlessLobbyConsole(server, in, out).start();
    }

    private static void startUI(LobbyServer server) {
        System.out.println("starting ui");
        LobbyAdminConsole console = new LobbyAdminConsole(server);
        console.setSize(800, 700);
        console.setLocationRelativeTo(null);
        console.setVisible(true);
    }

    public IServerMessenger getMessenger() {
        return (IServerMessenger)this.m_messengers.getMessenger();
    }

    public Messengers getMessengers() {
        return this.m_messengers;
    }
}

