/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.engine.message;

import games.strategy.engine.message.HubInvocationResults;
import games.strategy.engine.message.HubInvoke;
import games.strategy.engine.message.RemoteMethodCallResults;
import games.strategy.net.GUID;
import games.strategy.net.INode;

public class InvocationInProgress {
    private final INode m_waitingOn;
    private final HubInvoke m_methodCall;
    private final INode m_caller;
    private RemoteMethodCallResults m_results;

    public InvocationInProgress(INode waitingOn, HubInvoke methodCalls, INode methodCallsFrom) {
        this.m_waitingOn = waitingOn;
        this.m_methodCall = methodCalls;
        this.m_caller = methodCallsFrom;
    }

    public boolean isWaitingOn(INode node) {
        return this.m_waitingOn.equals(node);
    }

    public boolean process(HubInvocationResults hubresults, INode from) {
        if (hubresults.results == null) {
            throw new IllegalStateException("No results");
        }
        this.m_results = hubresults.results;
        if (!from.equals(this.m_waitingOn)) {
            throw new IllegalStateException("Wrong node, expecting " + this.m_waitingOn + " got " + from);
        }
        return true;
    }

    public HubInvoke getMethodCall() {
        return this.m_methodCall;
    }

    public INode getCaller() {
        return this.m_caller;
    }

    public RemoteMethodCallResults getResults() {
        return this.m_results;
    }

    public GUID getMethodCallID() {
        return this.m_methodCall.methodCallID;
    }

    public boolean shouldSendResults() {
        return this.m_methodCall.needReturnValues;
    }
}

