/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.engine.random;

import games.strategy.engine.random.IRemoteDiceServer;
import games.strategy.ui.Util;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.net.SocketException;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;

class HttpDiceRollerDialog
extends JDialog {
    private final JButton m_exitButton = new JButton("Exit");
    private final JButton m_reRollButton = new JButton("Roll Again");
    private final JButton m_okButton = new JButton("OK");
    private final JTextArea m_text = new JTextArea();
    private int[] m_diceRoll;
    private final int m_count;
    private final int m_sides;
    private final String m_subjectMessage;
    private final String m_gameID;
    private final IRemoteDiceServer m_diceServer;
    private final String m_gameUUID;
    private final Object m_lock = new Object();
    public boolean m_test = false;
    private final JPanel m_buttons = new JPanel();
    private final Window m_owner;

    public HttpDiceRollerDialog(Frame owner, int sides, int count, String subjectMessage, IRemoteDiceServer diceServer, String gameUUID) {
        super(owner, "Dice roller", true);
        this.m_owner = owner;
        this.m_sides = sides;
        this.m_count = count;
        this.m_subjectMessage = subjectMessage;
        this.m_gameID = diceServer.getGameId() == null ? "" : diceServer.getGameId();
        this.m_diceServer = diceServer;
        this.m_gameUUID = gameUUID;
        this.setDefaultCloseOperation(0);
        this.m_exitButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                System.exit(-1);
            }
        });
        this.m_exitButton.setEnabled(false);
        this.m_reRollButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                HttpDiceRollerDialog.this.rollInternal();
            }
        });
        this.m_okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                HttpDiceRollerDialog.this.closeAndReturn();
            }
        });
        this.m_reRollButton.setEnabled(false);
        this.getContentPane().setLayout(new BorderLayout());
        this.m_buttons.add(this.m_exitButton);
        this.m_buttons.add(this.m_reRollButton);
        this.getContentPane().add((Component)this.m_buttons, "South");
        this.getContentPane().add(new JScrollPane(this.m_text));
        this.m_text.setEditable(false);
        this.setSize(400, 300);
        Util.center(this);
    }

    public void setTest() {
        this.m_test = true;
        this.m_buttons.removeAll();
        this.m_buttons.add(this.m_okButton);
        this.m_buttons.add(this.m_reRollButton);
    }

    public void appendText(String aString) {
        this.m_text.setText(this.m_text.getText() + aString);
    }

    public void notifyError() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                HttpDiceRollerDialog.this.m_exitButton.setEnabled(true);
                HttpDiceRollerDialog.this.m_reRollButton.setEnabled(true);
            }
        });
    }

    public int[] getDiceRoll() {
        return this.m_diceRoll;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void roll() {
        if (!SwingUtilities.isEventDispatchThread()) {
            Object object = this.m_lock;
            synchronized (object) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        HttpDiceRollerDialog.this.roll();
                    }
                });
                try {
                    this.m_lock.wait();
                }
                catch (InterruptedException ie) {
                    ie.printStackTrace();
                }
            }
            return;
        }
        this.rollInternal();
        this.setVisible(true);
    }

    private void rollInternal() {
        if (!SwingUtilities.isEventDispatchThread()) {
            throw new IllegalStateException("Wrong thread");
        }
        this.m_reRollButton.setEnabled(false);
        this.m_exitButton.setEnabled(false);
        Thread t = new Thread("Triplea, roll in seperate thread"){

            public void run() {
                HttpDiceRollerDialog.this.rollInSeperateThread();
            }
        };
        t.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeAndReturn() {
        if (this.m_lock != null) {
            Object object = this.m_lock;
            synchronized (object) {
                this.m_lock.notifyAll();
            }
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                HttpDiceRollerDialog.this.setVisible(false);
                HttpDiceRollerDialog.this.m_owner.toFront();
            }
        });
    }

    private void rollInSeperateThread() {
        if (SwingUtilities.isEventDispatchThread()) {
            throw new IllegalStateException("Wrong thread");
        }
        while (!this.isVisible()) {
            Thread.yield();
        }
        this.appendText(this.m_subjectMessage + "\n");
        this.appendText("Contacting  " + this.m_diceServer.getDisplayName() + "\n");
        String text = null;
        try {
            text = this.m_diceServer.postRequest(this.m_sides, this.m_count, this.m_subjectMessage, this.m_gameID, this.m_gameUUID);
            if (text.length() == 0) {
                this.appendText("Nothing could be read from dice server\n");
                this.appendText("Please check your firewall settings");
                this.notifyError();
            }
            if (!this.m_test) {
                this.appendText("Contacted :" + text + "\n");
            }
            this.m_diceRoll = this.m_diceServer.getDice(text, this.m_count);
            this.appendText("Success!");
            if (!this.m_test) {
                this.closeAndReturn();
            }
        }
        catch (SocketException ex) {
            this.appendText("Connection failure:" + ex.getMessage() + "\n" + "Please ensure your Internet connection is working, and try again.");
            this.notifyError();
        }
        catch (InvocationTargetException e) {
            this.appendText("\nError:" + e.getMessage() + "\n\n");
            this.appendText("Text from dice server:\n" + text + "\n");
            this.notifyError();
        }
        catch (IOException ex) {
            try {
                this.appendText("An error has occured!\n");
                this.appendText("Possible reasons the error could have happened:\n");
                this.appendText("  1: An invalid e-mail address\n");
                this.appendText("  2: Firewall could be blocking TripleA from connecting to the Dice Server\n");
                this.appendText("  3: The e-mail address does not exist\n");
                this.appendText("  4: An unknown error, please see the error console and consult the forums for help\n");
                this.appendText("     Visit http://tripleadev.org  for extra help\n");
                if (text != null) {
                    this.appendText("Text from dice server:\n" + text + "\n");
                }
                StringWriter writer = new StringWriter();
                ex.printStackTrace(new PrintWriter(writer));
                writer.close();
                this.appendText(writer.toString());
            }
            catch (IOException ex1) {
                ex1.printStackTrace();
            }
            this.notifyError();
        }
    }
}

