/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.engine.random;

import games.strategy.engine.framework.startup.ui.editors.DiceServerEditor;
import games.strategy.engine.framework.startup.ui.editors.EditorPanel;
import games.strategy.engine.framework.startup.ui.editors.IBean;
import games.strategy.engine.random.IRandomSource;
import games.strategy.engine.random.IRemoteDiceServer;
import games.strategy.engine.random.PlainRandomSource;
import java.io.IOException;
import java.io.ObjectStreamException;
import java.lang.reflect.InvocationTargetException;

public class InternalDiceServer
implements IRemoteDiceServer {
    private static final long serialVersionUID = -8369097763085658445L;
    private transient IRandomSource _randomSource = new PlainRandomSource();

    public EditorPanel getEditor() {
        return new DiceServerEditor(this);
    }

    public boolean sameType(IBean other) {
        return other.getClass() == InternalDiceServer.class;
    }

    public String postRequest(int max, int numDice, String subjectMessage, String gameID, String gameUUID) throws IOException {
        int[] ints = this._randomSource.getRandom(max, numDice, "Internal Dice Server");
        StringBuilder sb = new StringBuilder();
        for (int i : ints) {
            sb.append(i).append(",");
        }
        String intArrayString = sb.substring(0, sb.length() - 1);
        return intArrayString;
    }

    public int[] getDice(String string, int count) throws IOException, InvocationTargetException {
        String[] strArray = string.split(",");
        int[] intArray = new int[strArray.length];
        for (int i = 0; i < strArray.length; ++i) {
            intArray[i] = Integer.parseInt(strArray[i]);
        }
        return intArray;
    }

    public String getDisplayName() {
        return "Internal Dice Roller";
    }

    public String getToAddress() {
        return null;
    }

    public void setToAddress(String toAddress) {
    }

    public String getCcAddress() {
        return null;
    }

    public void setCcAddress(String ccAddress) {
    }

    public String getInfoText() {
        return "Uses the build in TripleA dice roller.\nDice are not logged, and no internet access is required.\nIt is technically possible (for a hacker) to modify the dice rolls.";
    }

    public boolean sendsEmail() {
        return false;
    }

    public Object readResolve() throws ObjectStreamException {
        return new InternalDiceServer();
    }

    public boolean supportsGameId() {
        return false;
    }

    public void setGameId(String gameId) {
    }

    public String getGameId() {
        return null;
    }

    public String getHelpText() {
        return "<html>No help</html>";
    }
}

