/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.engine.random;

import games.strategy.engine.random.HttpDiceRollerDialog;
import games.strategy.engine.random.IRandomSource;
import games.strategy.engine.random.IRemoteDiceServer;
import java.awt.Frame;
import java.lang.reflect.InvocationTargetException;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.SwingUtilities;

public class PBEMDiceRoller
implements IRandomSource {
    private final String m_gameUUID;
    private final IRemoteDiceServer m_remoteDiceServer;
    private static Frame s_focusWindow;

    public static void setFocusWindow(Frame w) {
        s_focusWindow = w;
    }

    public PBEMDiceRoller(IRemoteDiceServer diceServer, String gameUUID) {
        this.m_remoteDiceServer = diceServer;
        this.m_gameUUID = gameUUID;
    }

    public void test() {
        HttpDiceRollerDialog dialog = new HttpDiceRollerDialog(this.getFocusedFrame(), 6, 1, "Test", this.m_remoteDiceServer, "test-roll");
        dialog.setTest();
        dialog.roll();
    }

    public int[] getRandom(final int max, final int count, final String annotation) {
        if (!SwingUtilities.isEventDispatchThread()) {
            final AtomicReference result = new AtomicReference();
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    public void run() {
                        result.set(PBEMDiceRoller.this.getRandom(max, count, annotation));
                    }
                });
            }
            catch (InterruptedException e) {
                throw new IllegalStateException(e);
            }
            catch (InvocationTargetException e) {
                throw new IllegalStateException(e);
            }
            return (int[])result.get();
        }
        HttpDiceRollerDialog dialog = new HttpDiceRollerDialog(this.getFocusedFrame(), max, count, annotation, this.m_remoteDiceServer, this.m_gameUUID);
        dialog.roll();
        return dialog.getDiceRoll();
    }

    private Frame getFocusedFrame() {
        if (s_focusWindow != null) {
            return s_focusWindow;
        }
        Frame[] frames = Frame.getFrames();
        Frame rVal = null;
        for (int i = 0; i < frames.length; ++i) {
            if (frames[i].isFocused()) {
                rVal = frames[i];
                continue;
            }
            if (rVal != null || !frames[i].isVisible()) continue;
            rVal = frames[i];
        }
        return rVal;
    }

    public int getRandom(int max, String annotation) {
        return this.getRandom(max, 1, annotation)[0];
    }
}

