/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.engine.random;

import games.strategy.util.IntegerMap;
import java.io.Serializable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RandomStatsDetails
implements Serializable {
    private final IntegerMap<Integer> m_data;
    private double m_average;
    private int m_total;
    private double m_median;
    private double m_stdDeviation;
    private double m_variance;

    public RandomStatsDetails(IntegerMap<Integer> data) {
        this.m_data = data;
        if (data.totalValues() != 0) {
            int sumTotal = 0;
            int total = 0;
            for (int i = 1; i <= 6; ++i) {
                sumTotal += i * this.m_data.getInt(i);
                total += this.m_data.getInt(i);
            }
            this.m_total = total;
            this.m_average = (double)sumTotal / (double)data.totalValues();
            if (total % 2 != 0) {
                this.m_median = this.calcMedian(total / 2 + 1);
            } else {
                double tmp1 = 0.0;
                double tmp2 = 0.0;
                tmp1 = this.calcMedian(total / 2);
                tmp2 = this.calcMedian(total / 2 + 1);
                this.m_median = (tmp1 + tmp2) / 2.0;
            }
            double variance = 0.0;
            for (int i = 1; i <= 6; ++i) {
                variance += (double)((this.m_data.getInt(i) - total / 6) * (this.m_data.getInt(i) - total / 6));
            }
            this.m_variance = variance / (double)(total - 1);
            this.m_stdDeviation = Math.sqrt(this.m_variance);
        } else {
            this.m_total = 0;
            this.m_median = 0.0;
            this.m_average = 0.0;
            this.m_stdDeviation = 0.0;
            this.m_variance = 0.0;
        }
    }

    public double getAverage() {
        return this.m_average;
    }

    public IntegerMap<Integer> getData() {
        return this.m_data;
    }

    public int getTotal() {
        return this.m_total;
    }

    public double getMedian() {
        return this.m_median;
    }

    public double getVariance() {
        return this.m_variance;
    }

    public double getStdDeviation() {
        return this.m_stdDeviation;
    }

    private int calcMedian(int centerPoint) {
        int sum = 0;
        int i = 1;
        for (i = 1; i <= 6; ++i) {
            if ((sum += this.m_data.getInt(i)) < centerPoint) continue;
            return i;
        }
        return i;
    }
}

