/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.engine.random;

import games.strategy.engine.framework.IGame;
import games.strategy.engine.framework.VerifiedRandomNumbers;
import games.strategy.engine.random.CryptoRandomSource;
import games.strategy.engine.random.IRemoteRandom;
import games.strategy.engine.random.PlainRandomSource;
import games.strategy.engine.vault.NotUnlockedException;
import games.strategy.engine.vault.Vault;
import games.strategy.engine.vault.VaultID;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoteRandom
implements IRemoteRandom {
    private static List<VerifiedRandomNumbers> s_verifiedRandomNumbers = new ArrayList<VerifiedRandomNumbers>();
    private final PlainRandomSource m_plainRandom = new PlainRandomSource();
    private final IGame m_game;
    private VaultID m_remoteVaultID;
    private String m_annotation;
    private int m_max;
    private boolean m_waitingForUnlock;
    private int[] m_localNumbers;

    public static synchronized List<VerifiedRandomNumbers> getVerifiedRandomNumbers() {
        return new ArrayList<VerifiedRandomNumbers>(s_verifiedRandomNumbers);
    }

    private static synchronized void addVerifiedRandomNumber(VerifiedRandomNumbers number) {
        s_verifiedRandomNumbers.add(number);
    }

    public RemoteRandom(IGame game) {
        this.m_game = game;
    }

    @Override
    public int[] generate(int max, int count, String annotation, VaultID remoteVaultID) {
        if (this.m_waitingForUnlock) {
            throw new IllegalStateException("Being asked to generate random numbers, but we havent finished last generation");
        }
        this.m_waitingForUnlock = true;
        if (this.m_remoteVaultID != null) {
            this.m_game.getVault().release(this.m_remoteVaultID);
        }
        this.m_remoteVaultID = remoteVaultID;
        this.m_annotation = annotation;
        this.m_max = max;
        this.m_localNumbers = this.m_plainRandom.getRandom(max, count, annotation);
        this.m_game.getVault().waitForID(remoteVaultID, 15000L);
        if (!this.m_game.getVault().knowsAbout(remoteVaultID)) {
            throw new IllegalStateException("Vault id not known, have:" + this.m_game.getVault().knownIds() + " looking for:" + remoteVaultID);
        }
        return this.m_localNumbers;
    }

    @Override
    public void verifyNumbers() {
        int[] remoteNumbers;
        Vault vault = this.m_game.getVault();
        vault.waitForIdToUnlock(this.m_remoteVaultID, 15000L);
        if (!vault.isUnlocked(this.m_remoteVaultID)) {
            throw new IllegalStateException("Server did not unlock random numbers, cheating is suspected");
        }
        try {
            remoteNumbers = CryptoRandomSource.bytesToInts(vault.get(this.m_remoteVaultID));
        }
        catch (NotUnlockedException e1) {
            e1.printStackTrace();
            throw new IllegalStateException("Could not unlock numbers, cheating suspected");
        }
        int[] verifiedNumbers = CryptoRandomSource.xor(remoteNumbers, this.m_localNumbers, this.m_max);
        RemoteRandom.addVerifiedRandomNumber(new VerifiedRandomNumbers(this.m_annotation, verifiedNumbers));
        this.m_waitingForUnlock = false;
    }
}

