/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.engine.vault;

import games.strategy.engine.message.IChannelMessenger;
import games.strategy.engine.message.RemoteName;
import games.strategy.engine.vault.IRemoteVault;
import games.strategy.engine.vault.NotUnlockedException;
import games.strategy.engine.vault.VaultID;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESKeySpec;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Vault {
    private static final RemoteName VAULT_CHANNEL = new RemoteName("games.strategy.engine.vault.IServerVault.VAULT_CHANNEL", IRemoteVault.class);
    private static final String ALGORITHM = "DES";
    private SecretKeyFactory mSecretKeyFactory;
    private static final byte[] KNOWN_VAL = new byte[]{12, 10, 15, 14, 11, 10, 11, 14};
    private final KeyGenerator m_keyGen;
    private final IChannelMessenger m_channelMessenger;
    private final ConcurrentMap<VaultID, SecretKey> m_secretKeys = new ConcurrentHashMap<VaultID, SecretKey>();
    private final ConcurrentMap<VaultID, byte[]> m_unverifiedValues = new ConcurrentHashMap<VaultID, byte[]>();
    private final ConcurrentMap<VaultID, byte[]> m_verifiedValues = new ConcurrentHashMap<VaultID, byte[]>();
    private final Object m_waitForLock = new Object();
    private final IRemoteVault m_remoteVault = new IRemoteVault(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addLockedValue(VaultID id, byte[] data) {
            if (id.getGeneratedOn().equals(Vault.this.m_channelMessenger.getLocalNode())) {
                return;
            }
            if (Vault.this.m_unverifiedValues.putIfAbsent(id, data) != null) {
                throw new IllegalStateException("duplicate values for id:" + id);
            }
            Object object = Vault.this.m_waitForLock;
            synchronized (object) {
                Vault.this.m_waitForLock.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void unlock(VaultID id, byte[] secretKeyBytes) {
            byte[] decrypted;
            Cipher cipher;
            if (id.getGeneratedOn().equals(Vault.this.m_channelMessenger.getLocalNode())) {
                return;
            }
            SecretKey key = Vault.this.bytesToKey(secretKeyBytes);
            try {
                cipher = Cipher.getInstance(Vault.ALGORITHM);
                cipher.init(2, key);
            }
            catch (NoSuchAlgorithmException e) {
                e.printStackTrace();
                throw new IllegalStateException(e.getMessage());
            }
            catch (NoSuchPaddingException e) {
                e.printStackTrace();
                throw new IllegalStateException(e.getMessage());
            }
            catch (InvalidKeyException e) {
                e.printStackTrace();
                throw new IllegalStateException(e.getMessage());
            }
            byte[] encrypted = (byte[])Vault.this.m_unverifiedValues.remove(id);
            try {
                decrypted = cipher.doFinal(encrypted);
            }
            catch (Exception e1) {
                e1.printStackTrace();
                throw new IllegalStateException(e1.getMessage());
            }
            if (decrypted.length < KNOWN_VAL.length) {
                throw new IllegalStateException("decrypted is not long enough to have known value, cheating is suspected");
            }
            for (int i = 0; i < KNOWN_VAL.length; ++i) {
                if (KNOWN_VAL[i] == decrypted[i]) continue;
                throw new IllegalStateException("Known value of cipher not correct, cheating is suspected");
            }
            byte[] data = new byte[decrypted.length - KNOWN_VAL.length];
            System.arraycopy(decrypted, KNOWN_VAL.length, data, 0, data.length);
            if (Vault.this.m_verifiedValues.putIfAbsent(id, data) != null) {
                throw new IllegalStateException("duplicate values for id:" + id);
            }
            Object object = Vault.this.m_waitForLock;
            synchronized (object) {
                Vault.this.m_waitForLock.notifyAll();
            }
        }

        public void release(VaultID id) {
            Vault.this.m_unverifiedValues.remove(id);
            Vault.this.m_verifiedValues.remove(id);
        }
    };

    public Vault(IChannelMessenger channelMessenger) {
        this.m_channelMessenger = channelMessenger;
        this.m_channelMessenger.registerChannelSubscriber(this.m_remoteVault, VAULT_CHANNEL);
        try {
            this.mSecretKeyFactory = SecretKeyFactory.getInstance(ALGORITHM);
            this.m_keyGen = KeyGenerator.getInstance(ALGORITHM);
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            throw new IllegalStateException("Nothing known about algorithm:DES");
        }
    }

    public void shutDown() {
        this.m_channelMessenger.unregisterChannelSubscriber(this.m_remoteVault, VAULT_CHANNEL);
    }

    private SecretKey bytesToKey(byte[] bytes) {
        try {
            DESKeySpec spec = new DESKeySpec(bytes);
            return this.mSecretKeyFactory.generateSecret(spec);
        }
        catch (GeneralSecurityException e) {
            throw new IllegalStateException(e.getMessage());
        }
    }

    private byte[] secretKeyToBytes(SecretKey key) {
        try {
            DESKeySpec ks = (DESKeySpec)this.mSecretKeyFactory.getKeySpec(key, DESKeySpec.class);
            return ks.getKey();
        }
        catch (GeneralSecurityException e) {
            throw new IllegalStateException(e.getMessage());
        }
    }

    private IRemoteVault getRemoteBroadcaster() {
        return (IRemoteVault)this.m_channelMessenger.getChannelBroadcastor(VAULT_CHANNEL);
    }

    public VaultID lock(byte[] data) {
        byte[] encrypted;
        Cipher cipher;
        SecretKey key;
        VaultID id = new VaultID(this.m_channelMessenger.getLocalNode());
        if (this.m_secretKeys.putIfAbsent(id, key = this.m_keyGen.generateKey()) != null) {
            throw new IllegalStateException("dupliagte id:" + id);
        }
        this.m_verifiedValues.put(id, data);
        try {
            cipher = Cipher.getInstance(ALGORITHM);
            cipher.init(1, key);
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            throw new IllegalStateException(e.getMessage());
        }
        catch (NoSuchPaddingException e) {
            e.printStackTrace();
            throw new IllegalStateException(e.getMessage());
        }
        catch (InvalidKeyException e) {
            e.printStackTrace();
            throw new IllegalStateException(e.getMessage());
        }
        byte[] dataAndCheck = Vault.joinDataAndKnown(data);
        try {
            encrypted = cipher.doFinal(dataAndCheck);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IllegalStateException(e.getMessage());
        }
        this.getRemoteBroadcaster().addLockedValue(id, encrypted);
        return id;
    }

    static byte[] joinDataAndKnown(byte[] data) {
        byte[] dataAndCheck = new byte[KNOWN_VAL.length + data.length];
        System.arraycopy(KNOWN_VAL, 0, dataAndCheck, 0, KNOWN_VAL.length);
        System.arraycopy(data, 0, dataAndCheck, KNOWN_VAL.length, data.length);
        return dataAndCheck;
    }

    public void unlock(VaultID id) {
        if (!id.getGeneratedOn().equals(this.m_channelMessenger.getLocalNode())) {
            throw new IllegalArgumentException("Cant unlock data that wasnt locked on this node");
        }
        SecretKey key = (SecretKey)this.m_secretKeys.remove(id);
        this.getRemoteBroadcaster().unlock(id, this.secretKeyToBytes(key));
    }

    public boolean isUnlocked(VaultID id) {
        return this.m_verifiedValues.containsKey(id);
    }

    public byte[] get(VaultID id) throws NotUnlockedException {
        if (this.m_verifiedValues.containsKey(id)) {
            return (byte[])this.m_verifiedValues.get(id);
        }
        if (this.m_unverifiedValues.containsKey(id)) {
            throw new NotUnlockedException();
        }
        throw new IllegalStateException("Nothing known about id:" + id);
    }

    public boolean knowsAbout(VaultID id) {
        return this.m_verifiedValues.containsKey(id) || this.m_unverifiedValues.containsKey(id);
    }

    public List<VaultID> knownIds() {
        ArrayList<VaultID> rVal = new ArrayList<VaultID>(this.m_verifiedValues.keySet());
        rVal.addAll(this.m_unverifiedValues.keySet());
        return rVal;
    }

    public void release(VaultID id) {
        this.getRemoteBroadcaster().release(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForID(VaultID id, long timeoutMS) {
        if (timeoutMS <= 0L) {
            throw new IllegalArgumentException("Must suppply positive timeout argument");
        }
        long endTime = timeoutMS + System.currentTimeMillis();
        while (System.currentTimeMillis() < endTime && !this.knowsAbout(id)) {
            Object object = this.m_waitForLock;
            synchronized (object) {
                if (this.knowsAbout(id)) {
                    return;
                }
                try {
                    long waitTime = endTime - System.currentTimeMillis();
                    if (waitTime > 0L) {
                        this.m_waitForLock.wait(waitTime);
                    }
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForIdToUnlock(VaultID id, long timeout) {
        if (timeout <= 0L) {
            throw new IllegalArgumentException("Must suppply positive timeout argument");
        }
        long startTime = System.currentTimeMillis();
        long leftToWait = timeout;
        while (leftToWait > 0L && !this.isUnlocked(id)) {
            Object object = this.m_waitForLock;
            synchronized (object) {
                if (this.isUnlocked(id)) {
                    return;
                }
                try {
                    this.m_waitForLock.wait(leftToWait);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                leftToWait = startTime + timeout - System.currentTimeMillis();
            }
        }
    }
}

